/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.base;

import android.os.AsyncTask;
import android.util.Log;
import com.folioreader.ui.base.HtmlTaskCallback;
import com.folioreader.util.AppUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class HtmlTask
extends AsyncTask<String, Void, String> {
    private static final String TAG = "HtmlTask";
    private HtmlTaskCallback callback;

    public HtmlTask(HtmlTaskCallback callback) {
        this.callback = callback;
    }

    protected String doInBackground(String ... urls) {
        String strUrl = urls[0];
        try {
            String line;
            URL url = new URL(strUrl);
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, AppUtil.charsetNameForURLConnection(urlConnection)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"HtmlTask failed", (Throwable)e);
            return null;
        }
    }

    protected void onPostExecute(String htmlString) {
        if (htmlString != null) {
            this.callback.onReceiveHtml(htmlString);
        } else {
            this.callback.onError();
        }
        this.cancel(true);
    }
}

