/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.HighlightImpl;
import com.folioreader.ui.view.UnderlinedTextView;
import com.folioreader.util.AppUtil;
import com.folioreader.util.UiUtil;
import java.util.List;

public class HighlightAdapter
extends RecyclerView.Adapter<HighlightHolder> {
    private List<HighlightImpl> highlights;
    private HighLightAdapterCallback callback;
    private Context context;
    private Config config;

    public HighlightAdapter(Context context, List<HighlightImpl> highlights, HighLightAdapterCallback callback, Config config) {
        this.context = context;
        this.highlights = highlights;
        this.callback = callback;
        this.config = config;
    }

    public HighlightHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new HighlightHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_highlight, parent, false));
    }

    public void onBindViewHolder(final HighlightHolder holder, final int position) {
        holder.container.postDelayed(new Runnable(){

            @Override
            public void run() {
                ((AppCompatActivity)HighlightAdapter.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        holder.container.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
                    }
                });
            }
        }, 10L);
        holder.content.setText((CharSequence)Html.fromHtml((String)this.getItem(position).getContent()));
        UiUtil.setBackColorToTextView(holder.content, this.getItem(position).getType());
        holder.date.setText((CharSequence)AppUtil.formatDate(this.getItem(position).getDate()));
        holder.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HighlightAdapter.this.callback.onItemClick(HighlightAdapter.this.getItem(position));
            }
        });
        holder.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HighlightAdapter.this.callback.deleteHighlight(HighlightAdapter.this.getItem(position).getId());
                HighlightAdapter.this.highlights.remove(position);
                HighlightAdapter.this.notifyDataSetChanged();
            }
        });
        holder.editNote.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HighlightAdapter.this.callback.editNote(HighlightAdapter.this.getItem(position), position);
            }
        });
        if (this.getItem(position).getNote() != null) {
            if (this.getItem(position).getNote().isEmpty()) {
                holder.note.setVisibility(8);
            } else {
                holder.note.setVisibility(0);
                holder.note.setText((CharSequence)this.getItem(position).getNote());
            }
        } else {
            holder.note.setVisibility(8);
        }
        holder.container.postDelayed(new Runnable(){

            @Override
            public void run() {
                final int height = holder.container.getHeight();
                ((AppCompatActivity)HighlightAdapter.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ViewGroup.LayoutParams params = holder.swipeLinearLayout.getLayoutParams();
                        params.height = height;
                        holder.swipeLinearLayout.setLayoutParams(params);
                    }
                });
            }
        }, 30L);
        if (this.config.isNightMode()) {
            holder.container.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
            holder.note.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            holder.date.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
        } else {
            holder.container.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            holder.note.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
            holder.date.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
        }
    }

    private HighlightImpl getItem(int position) {
        return this.highlights.get(position);
    }

    public int getItemCount() {
        return this.highlights.size();
    }

    public void editNote(String note, int position) {
        this.highlights.get(position).setNote(note);
        this.notifyDataSetChanged();
    }

    public static interface HighLightAdapterCallback {
        public void onItemClick(HighlightImpl var1);

        public void deleteHighlight(int var1);

        public void editNote(HighlightImpl var1, int var2);
    }

    static class HighlightHolder
    extends RecyclerView.ViewHolder {
        private UnderlinedTextView content;
        private ImageView delete;
        private ImageView editNote;
        private TextView date;
        private RelativeLayout container;
        private TextView note;
        private LinearLayout swipeLinearLayout;

        HighlightHolder(View itemView) {
            super(itemView);
            this.container = (RelativeLayout)itemView.findViewById(R.id.container);
            this.swipeLinearLayout = (LinearLayout)itemView.findViewById(R.id.swipe_linear_layout);
            this.content = (UnderlinedTextView)itemView.findViewById(R.id.utv_highlight_content);
            this.delete = (ImageView)itemView.findViewById(R.id.iv_delete);
            this.editNote = (ImageView)itemView.findViewById(R.id.iv_edit_note);
            this.date = (TextView)itemView.findViewById(R.id.tv_highlight_date);
            this.note = (TextView)itemView.findViewById(R.id.tv_note);
        }
    }
}

