/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.activity;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProviders;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.locators.SearchLocator;
import com.folioreader.ui.activity.SearchActivity;
import com.folioreader.ui.adapter.ListViewType;
import com.folioreader.ui.adapter.OnItemClickListener;
import com.folioreader.ui.adapter.SearchAdapter;
import com.folioreader.ui.view.FolioSearchView;
import com.folioreader.util.AppUtil;
import com.folioreader.util.UiUtil;
import com.folioreader.viewmodels.SearchViewModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u00012\u00020\u0002:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0016J\u0012\u0010\"\u001a\u00020\u001c2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0012\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J.\u0010&\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200H\u0014J\u0012\u00101\u001a\u00020\u00162\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/folioreader/ui/activity/SearchActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/folioreader/ui/adapter/OnItemClickListener;", "()V", "actionBar", "Landroidx/appcompat/app/ActionBar;", "collapseButtonView", "Landroid/widget/ImageButton;", "linearLayoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "savedInstanceState", "Landroid/os/Bundle;", "searchAdapter", "Lcom/folioreader/ui/adapter/SearchAdapter;", "searchAdapterDataBundle", "searchUri", "Landroid/net/Uri;", "searchView", "Lcom/folioreader/ui/view/FolioSearchView;", "searchViewModel", "Lcom/folioreader/viewmodels/SearchViewModel;", "softKeyboardVisible", "", "spineSize", "", "toolbarOnLayoutChangeListener", "Landroid/view/View$OnLayoutChangeListener;", "handleSearch", "", "init", "config", "Lcom/folioreader/Config;", "navigateBack", "onBackPressed", "onCreate", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onItemClick", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "viewHolder", "position", "id", "", "onNewIntent", "intent", "Landroid/content/Intent;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onRestoreInstanceState", "onSaveInstanceState", "outState", "Companion", "ResultCode", "folioreader_release"})
public final class SearchActivity
extends AppCompatActivity
implements OnItemClickListener {
    private int spineSize;
    private Uri searchUri;
    private FolioSearchView searchView;
    private ActionBar actionBar;
    private ImageButton collapseButtonView;
    private LinearLayoutManager linearLayoutManager;
    private SearchAdapter searchAdapter;
    private Bundle searchAdapterDataBundle;
    private Bundle savedInstanceState;
    private boolean softKeyboardVisible = true;
    private SearchViewModel searchViewModel;
    private final View.OnLayoutChangeListener toolbarOnLayoutChangeListener = new View.OnLayoutChangeListener(this){
        final /* synthetic */ SearchActivity this$0;

        /*
         * WARNING - void declaration
         */
        public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            int n = 0;
            Toolbar toolbar = (Toolbar)this.this$0._$_findCachedViewById(R.id.toolbar);
            Intrinsics.checkExpressionValueIsNotNull((Object)toolbar, (String)"toolbar");
            int n2 = toolbar.getChildCount();
            while (n < n2) {
                View view;
                void i;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Toolbar)this.this$0._$_findCachedViewById(R.id.toolbar)).getChildAt((int)i), (String)"toolbar.getChildAt(i)");
                String contentDescription = (String)view.getContentDescription();
                if (!TextUtils.isEmpty((CharSequence)contentDescription) && Intrinsics.areEqual((Object)contentDescription, (Object)"Collapse")) {
                    Log.v((String)SearchActivity.LOG_TAG, (String)"-> initActionBar -> mCollapseButtonView found");
                    View view2 = view;
                    if (view2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.widget.ImageButton");
                    }
                    SearchActivity.access$setCollapseButtonView$p(this.this$0, (ImageButton)view2);
                    ImageButton imageButton = SearchActivity.access$getCollapseButtonView$p(this.this$0);
                    if (imageButton != null) {
                        imageButton.setOnClickListener(new View.OnClickListener(this){
                            final /* synthetic */ toolbarOnLayoutChangeListener.1 this$0;

                            public final void onClick(View it) {
                                Log.v((String)SearchActivity.LOG_TAG, (String)"-> onClick -> collapseButtonView");
                                SearchActivity.access$navigateBack(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    ((Toolbar)this.this$0._$_findCachedViewById(R.id.toolbar)).removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    return;
                }
                ++i;
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    @JvmField
    @NotNull
    public static final String LOG_TAG;
    @NotNull
    public static final String BUNDLE_SPINE_SIZE = "BUNDLE_SPINE_SIZE";
    @NotNull
    public static final String BUNDLE_SEARCH_URI = "BUNDLE_SEARCH_URI";
    @NotNull
    public static final String BUNDLE_SAVE_SEARCH_QUERY = "BUNDLE_SAVE_SEARCH_QUERY";
    @NotNull
    public static final String BUNDLE_IS_SOFT_KEYBOARD_VISIBLE = "BUNDLE_IS_SOFT_KEYBOARD_VISIBLE";
    @NotNull
    public static final String BUNDLE_FIRST_VISIBLE_ITEM_INDEX = "BUNDLE_FIRST_VISIBLE_ITEM_INDEX";
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Config config;
        super.onCreate(savedInstanceState);
        Log.v((String)LOG_TAG, (String)"-> onCreate");
        Config config2 = AppUtil.Companion.getSavedConfig((Context)this);
        if (config2 == null) {
            Intrinsics.throwNpe();
        }
        if ((config = config2).isNightMode()) {
            this.setTheme(R.style.FolioNightTheme);
        } else {
            this.setTheme(R.style.FolioDayTheme);
        }
        this.setContentView(R.layout.activity_search);
        this.init(config);
    }

    private final void init(Config config) {
        Log.v((String)LOG_TAG, (String)"-> init");
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.toolbar));
        ((Toolbar)this._$_findCachedViewById(R.id.toolbar)).addOnLayoutChangeListener(this.toolbarOnLayoutChangeListener);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar == null) {
            Intrinsics.throwNpe();
        }
        ActionBar actionBar2 = this.actionBar = actionBar;
        if (actionBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionBar");
        }
        actionBar2.setDisplayHomeAsUpEnabled(true);
        ActionBar actionBar3 = this.actionBar;
        if (actionBar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionBar");
        }
        actionBar3.setDisplayShowTitleEnabled(false);
        try {
            Field field = Toolbar.class.getDeclaredField("mCollapseIcon");
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"Toolbar::class.java.getD\u2026redField(\"mCollapseIcon\")");
            Field fieldCollapseIcon = field;
            fieldCollapseIcon.setAccessible(true);
            Object object = fieldCollapseIcon.get((Toolbar)this._$_findCachedViewById(R.id.toolbar));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.Drawable");
            }
            Drawable collapseIcon = (Drawable)object;
            UiUtil.setColorIntToDrawable(config.getCurrentThemeColor(), collapseIcon);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"-> ", (Throwable)e);
        }
        this.spineSize = this.getIntent().getIntExtra(BUNDLE_SPINE_SIZE, 0);
        Parcelable parcelable = this.getIntent().getParcelableExtra(BUNDLE_SEARCH_URI);
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"intent.getParcelableExtra(BUNDLE_SEARCH_URI)");
        this.searchUri = (Uri)parcelable;
        SearchAdapter searchAdapter = this.searchAdapter = new SearchAdapter((Context)this);
        if (searchAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapter");
        }
        searchAdapter.setOnItemClickListener(this);
        this.linearLayoutManager = new LinearLayoutManager((Context)this);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recyclerView");
        LinearLayoutManager linearLayoutManager = this.linearLayoutManager;
        if (linearLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linearLayoutManager");
        }
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"recyclerView");
        SearchAdapter searchAdapter2 = this.searchAdapter;
        if (searchAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapter");
        }
        recyclerView2.setAdapter((RecyclerView.Adapter)searchAdapter2);
        ViewModel viewModel = ViewModelProviders.of((FragmentActivity)((FragmentActivity)this)).get(SearchViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProviders.of(th\u2026rchViewModel::class.java)");
        SearchViewModel searchViewModel = this.searchViewModel = (SearchViewModel)viewModel;
        if (searchViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
        }
        Object object = searchViewModel.getLiveAdapterDataBundle().getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        this.searchAdapterDataBundle = (Bundle)object;
        Bundle bundleFromFolioActivity = this.getIntent().getBundleExtra("DATA_BUNDLE");
        if (bundleFromFolioActivity != null) {
            SearchViewModel searchViewModel2 = this.searchViewModel;
            if (searchViewModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
            }
            searchViewModel2.getLiveAdapterDataBundle().setValue((Object)bundleFromFolioActivity);
            this.searchAdapterDataBundle = bundleFromFolioActivity;
            SearchAdapter searchAdapter3 = this.searchAdapter;
            if (searchAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapter");
            }
            searchAdapter3.changeDataBundle(bundleFromFolioActivity);
            int position = bundleFromFolioActivity.getInt(BUNDLE_FIRST_VISIBLE_ITEM_INDEX);
            Log.d((String)LOG_TAG, (String)("-> onCreate -> scroll to previous position " + position));
            ((RecyclerView)this._$_findCachedViewById(R.id.recyclerView)).scrollToPosition(position);
        }
        SearchViewModel searchViewModel3 = this.searchViewModel;
        if (searchViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
        }
        searchViewModel3.getLiveAdapterDataBundle().observe((LifecycleOwner)this, (Observer)new Observer<Bundle>(this){
            final /* synthetic */ SearchActivity this$0;

            public final void onChanged(Bundle dataBundle) {
                Bundle bundle = dataBundle;
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"dataBundle");
                SearchActivity.access$setSearchAdapterDataBundle$p(this.this$0, bundle);
                SearchActivity.access$getSearchAdapter$p(this.this$0).changeDataBundle(dataBundle);
            }
            {
                this.this$0 = searchActivity;
            }
        });
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Log.v((String)LOG_TAG, (String)"-> onNewIntent");
        if (intent.hasExtra(BUNDLE_SEARCH_URI)) {
            Parcelable parcelable = intent.getParcelableExtra(BUNDLE_SEARCH_URI);
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"intent.getParcelableExtra(BUNDLE_SEARCH_URI)");
            this.searchUri = (Uri)parcelable;
        } else {
            Uri uri = this.searchUri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchUri");
            }
            intent.putExtra(BUNDLE_SEARCH_URI, (Parcelable)uri);
            intent.putExtra(BUNDLE_SPINE_SIZE, this.spineSize);
        }
        this.setIntent(intent);
        if (Intrinsics.areEqual((Object)"android.intent.action.SEARCH", (Object)intent.getAction())) {
            this.handleSearch();
        }
    }

    private final void handleSearch() {
        Log.v((String)LOG_TAG, (String)"-> handleSearch");
        String string2 = this.getIntent().getStringExtra("query");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"intent.getStringExtra(SearchManager.QUERY)");
        String query = string2;
        Bundle newDataBundle = new Bundle();
        newDataBundle.putString("LIST_VIEW_TYPE", ListViewType.PAGINATION_IN_PROGRESS_VIEW.toString());
        newDataBundle.putParcelableArrayList("DATA", new ArrayList());
        SearchViewModel searchViewModel = this.searchViewModel;
        if (searchViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
        }
        searchViewModel.getLiveAdapterDataBundle().setValue((Object)newDataBundle);
        SearchViewModel searchViewModel2 = this.searchViewModel;
        if (searchViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
        }
        searchViewModel2.search(this.spineSize, query);
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        Log.v((String)LOG_TAG, (String)"-> onSaveInstanceState");
        FolioSearchView folioSearchView = this.searchView;
        if (folioSearchView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        outState.putCharSequence(BUNDLE_SAVE_SEARCH_QUERY, folioSearchView.getQuery());
        outState.putBoolean(BUNDLE_IS_SOFT_KEYBOARD_VISIBLE, this.softKeyboardVisible);
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        Log.v((String)LOG_TAG, (String)"-> onRestoreInstanceState");
        this.savedInstanceState = savedInstanceState;
    }

    private final void navigateBack() {
        Log.v((String)LOG_TAG, (String)"-> navigateBack");
        Intent intent = new Intent();
        Bundle bundle = this.searchAdapterDataBundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapterDataBundle");
        }
        LinearLayoutManager linearLayoutManager = this.linearLayoutManager;
        if (linearLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linearLayoutManager");
        }
        bundle.putInt(BUNDLE_FIRST_VISIBLE_ITEM_INDEX, linearLayoutManager.findFirstVisibleItemPosition());
        Bundle bundle2 = this.searchAdapterDataBundle;
        if (bundle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapterDataBundle");
        }
        intent.putExtra("DATA_BUNDLE", bundle2);
        FolioSearchView folioSearchView = this.searchView;
        if (folioSearchView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        intent.putExtra(BUNDLE_SAVE_SEARCH_QUERY, folioSearchView.getQuery());
        this.setResult(ResultCode.BACK_BUTTON_PRESSED.getValue(), intent);
        this.finish();
    }

    public void onBackPressed() {
        Log.v((String)LOG_TAG, (String)"-> onBackPressed");
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu2) {
        Log.v((String)LOG_TAG, (String)"-> onCreateOptionsMenu");
        MenuInflater menuInflater = this.getMenuInflater();
        Menu menu3 = menu2;
        if (menu3 == null) {
            Intrinsics.throwNpe();
        }
        menuInflater.inflate(R.menu.menu_search, menu3);
        Config config = AppUtil.Companion.getSavedConfig(this.getApplicationContext());
        if (config == null) {
            Intrinsics.throwNpe();
        }
        Config config2 = config;
        MenuItem menuItem = menu2.findItem(R.id.itemSearch);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"menu.findItem(R.id.itemSearch)");
        MenuItem itemSearch = menuItem;
        UiUtil.setColorIntToDrawable(config2.getCurrentThemeColor(), itemSearch.getIcon());
        View view = itemSearch.getActionView();
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.folioreader.ui.view.FolioSearchView");
        }
        FolioSearchView folioSearchView = this.searchView = (FolioSearchView)view;
        if (folioSearchView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        ComponentName componentName = this.getComponentName();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"componentName");
        folioSearchView.init(componentName, config2);
        itemSearch.expandActionView();
        if (this.savedInstanceState != null) {
            FolioSearchView folioSearchView2 = this.searchView;
            if (folioSearchView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
            }
            Bundle bundle = this.savedInstanceState;
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            folioSearchView2.setQuery(bundle.getCharSequence(BUNDLE_SAVE_SEARCH_QUERY), false);
            Bundle bundle2 = this.savedInstanceState;
            if (bundle2 == null) {
                Intrinsics.throwNpe();
            }
            this.softKeyboardVisible = bundle2.getBoolean(BUNDLE_IS_SOFT_KEYBOARD_VISIBLE);
            if (!this.softKeyboardVisible) {
                AppUtil.Companion.hideKeyboard((Activity)this);
            }
        } else {
            CharSequence searchQuery = this.getIntent().getCharSequenceExtra(BUNDLE_SAVE_SEARCH_QUERY);
            if (!TextUtils.isEmpty((CharSequence)searchQuery)) {
                FolioSearchView folioSearchView3 = this.searchView;
                if (folioSearchView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
                }
                folioSearchView3.setQuery(searchQuery, false);
                AppUtil.Companion.hideKeyboard((Activity)this);
                this.softKeyboardVisible = false;
            }
        }
        FolioSearchView folioSearchView4 = this.searchView;
        if (folioSearchView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        folioSearchView4.setOnQueryTextListener(new SearchView.OnQueryTextListener(this){
            final /* synthetic */ SearchActivity this$0;

            public boolean onQueryTextSubmit(@Nullable String query) {
                SearchActivity.access$setSoftKeyboardVisible$p(this.this$0, false);
                SearchActivity.access$getSearchView$p(this.this$0).clearFocus();
                return false;
            }

            public boolean onQueryTextChange(@Nullable String newText) {
                if (TextUtils.isEmpty((CharSequence)newText)) {
                    Log.v((String)SearchActivity.LOG_TAG, (String)"-> onQueryTextChange -> Empty Query");
                    SearchActivity.access$getSearchViewModel$p(this.this$0).cancelAllSearchCalls();
                    SearchActivity.access$getSearchViewModel$p(this.this$0).init();
                    Intent intent = new Intent("ACTION_SEARCH_CLEAR");
                    LocalBroadcastManager.getInstance((Context)((Context)this.this$0)).sendBroadcast(intent);
                }
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
        itemSearch.setOnActionExpandListener(new MenuItem.OnActionExpandListener(this){
            final /* synthetic */ SearchActivity this$0;

            public boolean onMenuItemActionExpand(@Nullable MenuItem item) {
                return true;
            }

            public boolean onMenuItemActionCollapse(@Nullable MenuItem item) {
                Log.v((String)SearchActivity.LOG_TAG, (String)"-> onMenuItemActionCollapse");
                SearchActivity.access$navigateBack(this.this$0);
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
        FolioSearchView folioSearchView5 = this.searchView;
        if (folioSearchView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        folioSearchView5.setOnQueryTextFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ SearchActivity this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    SearchActivity.access$setSoftKeyboardVisible$p(this.this$0, true);
                }
            }
            {
                this.this$0 = searchActivity;
            }
        });
        return true;
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        Integer itemId;
        MenuItem menuItem = item;
        Integer n = itemId = menuItem != null ? Integer.valueOf(menuItem.getItemId()) : null;
        int n2 = R.id.itemSearch;
        if (n != null && n == n2) {
            Log.v((String)LOG_TAG, (String)("-> onOptionsItemSelected -> " + item.getTitle()));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemClick(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter, @NotNull RecyclerView.ViewHolder viewHolder, int position, long id2) {
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        if (adapter instanceof SearchAdapter && viewHolder instanceof SearchAdapter.NormalViewHolder) {
            Log.v((String)LOG_TAG, (String)("-> onItemClick -> " + (Object)((Object)((SearchAdapter.NormalViewHolder)viewHolder).getSearchLocator())));
            Intent intent = new Intent();
            Bundle bundle = this.searchAdapterDataBundle;
            if (bundle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapterDataBundle");
            }
            LinearLayoutManager linearLayoutManager = this.linearLayoutManager;
            if (linearLayoutManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"linearLayoutManager");
            }
            bundle.putInt(BUNDLE_FIRST_VISIBLE_ITEM_INDEX, linearLayoutManager.findFirstVisibleItemPosition());
            Bundle bundle2 = this.searchAdapterDataBundle;
            if (bundle2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapterDataBundle");
            }
            intent.putExtra("DATA_BUNDLE", bundle2);
            SearchLocator searchLocator = ((SearchAdapter.NormalViewHolder)viewHolder).getSearchLocator();
            if (searchLocator == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.Parcelable");
            }
            intent.putExtra("EXTRA_SEARCH_ITEM", (Parcelable)searchLocator);
            FolioSearchView folioSearchView = this.searchView;
            if (folioSearchView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
            }
            intent.putExtra(BUNDLE_SAVE_SEARCH_QUERY, folioSearchView.getQuery());
            this.setResult(ResultCode.ITEM_SELECTED.getValue(), intent);
            this.finish();
        }
    }

    static {
        Companion = new Companion(null);
        String string2 = SearchActivity.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SearchActivity::class.java.simpleName");
        LOG_TAG = string2;
    }

    public static final /* synthetic */ Bundle access$getSearchAdapterDataBundle$p(SearchActivity $this) {
        Bundle bundle = $this.searchAdapterDataBundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapterDataBundle");
        }
        return bundle;
    }

    public static final /* synthetic */ void access$setSearchAdapterDataBundle$p(SearchActivity $this, Bundle bundle) {
        $this.searchAdapterDataBundle = bundle;
    }

    public static final /* synthetic */ SearchAdapter access$getSearchAdapter$p(SearchActivity $this) {
        SearchAdapter searchAdapter = $this.searchAdapter;
        if (searchAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAdapter");
        }
        return searchAdapter;
    }

    public static final /* synthetic */ void access$setSearchAdapter$p(SearchActivity $this, SearchAdapter searchAdapter) {
        $this.searchAdapter = searchAdapter;
    }

    public static final /* synthetic */ boolean access$getSoftKeyboardVisible$p(SearchActivity $this) {
        return $this.softKeyboardVisible;
    }

    public static final /* synthetic */ void access$setSoftKeyboardVisible$p(SearchActivity $this, boolean bl) {
        $this.softKeyboardVisible = bl;
    }

    public static final /* synthetic */ FolioSearchView access$getSearchView$p(SearchActivity $this) {
        FolioSearchView folioSearchView = $this.searchView;
        if (folioSearchView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchView");
        }
        return folioSearchView;
    }

    public static final /* synthetic */ void access$setSearchView$p(SearchActivity $this, FolioSearchView folioSearchView) {
        $this.searchView = folioSearchView;
    }

    public static final /* synthetic */ SearchViewModel access$getSearchViewModel$p(SearchActivity $this) {
        SearchViewModel searchViewModel = $this.searchViewModel;
        if (searchViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchViewModel");
        }
        return searchViewModel;
    }

    public static final /* synthetic */ void access$setSearchViewModel$p(SearchActivity $this, SearchViewModel searchViewModel) {
        $this.searchViewModel = searchViewModel;
    }

    public static final /* synthetic */ void access$navigateBack(SearchActivity $this) {
        $this.navigateBack();
    }

    public static final /* synthetic */ ImageButton access$getCollapseButtonView$p(SearchActivity $this) {
        return $this.collapseButtonView;
    }

    public static final /* synthetic */ void access$setCollapseButtonView$p(SearchActivity $this, ImageButton imageButton) {
        $this.collapseButtonView = imageButton;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/folioreader/ui/activity/SearchActivity$ResultCode;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "ITEM_SELECTED", "BACK_BUTTON_PRESSED", "folioreader_release"})
    public static final class ResultCode
    extends Enum<ResultCode> {
        public static final /* enum */ ResultCode ITEM_SELECTED;
        public static final /* enum */ ResultCode BACK_BUTTON_PRESSED;
        private static final /* synthetic */ ResultCode[] $VALUES;
        private final int value;

        static {
            ResultCode[] resultCodeArray = new ResultCode[2];
            ResultCode[] resultCodeArray2 = resultCodeArray;
            resultCodeArray[0] = ITEM_SELECTED = new ResultCode(2);
            resultCodeArray[1] = BACK_BUTTON_PRESSED = new ResultCode(3);
            $VALUES = resultCodeArray;
        }

        public final int getValue() {
            return this.value;
        }

        private ResultCode(int value) {
            this.value = value;
        }

        public static ResultCode[] values() {
            return (ResultCode[])$VALUES.clone();
        }

        public static ResultCode valueOf(String string2) {
            return Enum.valueOf(ResultCode.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/folioreader/ui/activity/SearchActivity$Companion;", "", "()V", "BUNDLE_FIRST_VISIBLE_ITEM_INDEX", "", "BUNDLE_IS_SOFT_KEYBOARD_VISIBLE", "BUNDLE_SAVE_SEARCH_QUERY", "BUNDLE_SEARCH_URI", "BUNDLE_SPINE_SIZE", "LOG_TAG", "folioreader_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

