/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import com.jibestream.jmapandroidsdk.collections.MapCollection;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.navigationkit.NavigationKit;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.instructionfactory.Instruction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import java.util.ArrayList;

public class InstructionFactory {
    private NavigationKit navKit;
    private JController controller;
    private int visualLimitLeft;
    private int visualLimitRight;
    private int visualRange;
    private ArrayList<String> layersOfInterest;
    private ArrayList<String> visualObstacles;

    public InstructionFactory(@NonNull NavigationKit navigationKit, @NonNull JController jController) {
        InstructionFactory instructionFactory = this;
        this.navKit = navigationKit;
        instructionFactory.controller = jController;
        instructionFactory.visualLimitLeft = 60;
        instructionFactory.visualLimitRight = 60;
        instructionFactory.visualRange = 250;
        instructionFactory.layersOfInterest = new ArrayList();
        instructionFactory.visualObstacles = new ArrayList();
    }

    public Instruction createFromDirection(@NonNull Direction direction) {
        Instruction instruction;
        Instruction instruction2;
        Instruction instruction3 = instruction2 = instruction;
        instruction3(direction);
        this.setSurroundingDefinitionWithInstruction(instruction3);
        this.setSurroundingElementsWithInstruction(instruction2);
        return instruction;
    }

    public Instruction createEmpty() {
        return new Instruction();
    }

    public void setSurroundingElementsWithInstruction(@NonNull Instruction instruction) {
        instruction.setSurroundingElements(this.navKit.getSurroundingElements(instruction.getSurroundingDefinition()));
    }

    public void setSurroundingDefinitionWithInstruction(@NonNull Instruction instruction) {
        SurroundingDefinition surroundingDefinition;
        PointF pointF;
        Instruction instruction2 = instruction;
        MapCollection mapCollection = this.controller.getActiveVenue().getMaps();
        Waypoint waypoint = instruction2.getOriginPoint();
        Waypoint waypoint2 = instruction2.getDecisionPoint();
        if (waypoint2 == null && instruction.getCompletionPoint() != null) {
            waypoint2 = instruction.getCompletionPoint();
        }
        if ((mapCollection = mapCollection.getById(waypoint.getMapId())) == null) {
            return;
        }
        Instruction instruction3 = instruction;
        instruction = pointF;
        pointF = new PointF(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue());
        SurroundingDefinition surroundingDefinition2 = surroundingDefinition;
        surroundingDefinition2((Map)mapCollection, (PointF)instruction);
        surroundingDefinition2.setGazeDirection(Direction.getAngle(waypoint, waypoint2));
        surroundingDefinition2.setVisualLimitLeft(this.visualLimitLeft);
        surroundingDefinition2.setVisualLimitRight(this.visualLimitRight);
        surroundingDefinition2.setVisualRange(this.visualRange);
        surroundingDefinition2.addAllLayersOfInterest(this.layersOfInterest);
        surroundingDefinition.addAllLayersOfInterest(this.visualObstacles);
        instruction3.setSurroundingDefinition(surroundingDefinition);
    }

    public SurroundingDefinition getSurroundingDefinitionForInstruction(@NonNull Instruction instruction) {
        return instruction.getSurroundingDefinition();
    }

    public int getVisualLimitLeft() {
        return this.visualLimitLeft;
    }

    public void setVisualLimitLeft(int n) {
        this.visualLimitLeft = n;
    }

    public int getVisualLimitRight() {
        return this.visualLimitRight;
    }

    public void setVisualLimitRight(int n) {
        this.visualLimitRight = n;
    }

    public int getVisualRange() {
        return this.visualRange;
    }

    public void setVisualRange(int n) {
        this.visualRange = n;
    }

    public void addLayerOfInterest(@NonNull String string) {
        this.layersOfInterest.add(string);
    }

    public void removeLayerOfInterest(@NonNull String string) {
        this.layersOfInterest.remove(string);
    }

    public void addVisualObstacles(@NonNull String string) {
        this.visualObstacles.add(string);
    }

    public void removeVisualObstacles(@NonNull String string) {
        this.visualObstacles.remove(string);
    }
}

