/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;

public class Instruction {
    private String direction;
    private String text;
    private String defaultInstruction;
    private float turnReferenceAngle;
    private float pixelDistance;
    private PathType pathType;
    private Waypoint originPoint;
    private Waypoint decisionPoint;
    private Waypoint completionPoint;
    private Floor nextFloor;
    private SurroundingDefinition surroundingDefinition;
    private SurroundingElements surroundingElements;

    public Instruction() {
    }

    public Instruction(@NonNull Direction direction) {
        this.setDistanceWithDirection(direction);
        this.setPointsWithDirection(direction);
        this.setTextWithDirection(direction);
    }

    public void setDistanceWithDirection(@NonNull Direction doubleArray) {
        if (doubleArray != null && doubleArray.getA() != null && doubleArray.getB() != null) {
            Double[] doubleArray2 = doubleArray.getA().getCoordinates();
            doubleArray = doubleArray.getB().getCoordinates();
            if (doubleArray2.length > 0 && doubleArray.length > 0) {
                this.pixelDistance = Math.round(Math.sqrt(Math.pow(doubleArray[0].floatValue() - doubleArray2[0].floatValue(), 2.0) + Math.pow(doubleArray[1].floatValue() - doubleArray2[1].floatValue(), 2.0)));
            }
            return;
        }
    }

    public void setPointsWithDirection(@NonNull Direction direction) {
        this.originPoint = direction.getA();
        Waypoint waypoint = direction.getC() != null ? direction.getB() : null;
        this.decisionPoint = waypoint;
        direction = direction.getC() != null ? direction.getC() : direction.getB();
        this.completionPoint = direction;
    }

    public void setTextWithDirection(@NonNull Direction direction) {
        this.direction = direction.getValue();
        this.text = direction.getC() != null ? "Turn " + direction.getValue() : "Arrive at your destination";
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(@NonNull String string) {
        this.direction = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NonNull String string) {
        this.text = string;
    }

    public String getDefaultInstruction() {
        return this.defaultInstruction;
    }

    public void setDefaultInstruction(@NonNull String string) {
        this.defaultInstruction = string;
    }

    public float getTurnReferenceAngle() {
        return this.turnReferenceAngle;
    }

    public void setTurnReferenceAngle(float f) {
        this.turnReferenceAngle = f;
    }

    public float getPixelDistance() {
        return this.pixelDistance;
    }

    public void setPixelDistance(float f) {
        this.pixelDistance = f;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(@Nullable PathType pathType) {
        this.pathType = pathType;
    }

    public Waypoint getOriginPoint() {
        return this.originPoint;
    }

    public void setOriginPoint(@NonNull Waypoint waypoint) {
        this.originPoint = waypoint;
    }

    public Waypoint getDecisionPoint() {
        return this.decisionPoint;
    }

    public void setDecisionPoint(@Nullable Waypoint waypoint) {
        this.decisionPoint = waypoint;
    }

    public Waypoint getCompletionPoint() {
        return this.completionPoint;
    }

    public void setCompletionPoint(@NonNull Waypoint waypoint) {
        this.completionPoint = waypoint;
    }

    public Floor getNextFloor() {
        return this.nextFloor;
    }

    public void setNextFloor(@Nullable Floor floor) {
        this.nextFloor = floor;
    }

    public SurroundingDefinition getSurroundingDefinition() {
        return this.surroundingDefinition;
    }

    public void setSurroundingDefinition(@NonNull SurroundingDefinition surroundingDefinition) {
        this.surroundingDefinition = surroundingDefinition;
    }

    public SurroundingElements getSurroundingElements() {
        return this.surroundingElements;
    }

    public void setSurroundingElements(@NonNull SurroundingElements surroundingElements) {
        this.surroundingElements = surroundingElements;
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder().append("");
        String string = ((Instruction)((Object)string2)).direction != null ? "direction = " + ((Instruction)((Object)string2)).direction + "\n" : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).text != null ? "text = " + ((Instruction)((Object)string2)).text + "\n" : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).defaultInstruction != null ? "defaultInstruction = " + ((Instruction)((Object)string2)).defaultInstruction + "\n" : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = (String)charSequence + "turnReferenceAngle = " + ((Instruction)((Object)string2)).turnReferenceAngle + "\n";
        charSequence = (String)charSequence + "pixelDistance = " + ((Instruction)((Object)string2)).pixelDistance + "\n";
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).pathType != null ? "pathType = " + ((Instruction)((Object)string2)).pathType.toString() + "\n" : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).originPoint != null ? "originPoint = " + ((Instruction)((Object)string2)).originPoint + "\n" : "originPoint = null\n";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).decisionPoint != null ? "decisionPoint = " + ((Instruction)((Object)string2)).decisionPoint + "\n" : "decisionPoint = null\n";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).completionPoint != null ? "completionPoint = " + ((Instruction)((Object)string2)).completionPoint + "\n" : "completionPoint = null\n";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).nextFloor != null ? "nextFloor = " + ((Instruction)((Object)string2)).nextFloor + "\n" : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        string = ((Instruction)((Object)string2)).surroundingDefinition != null ? "surroundingDefinition = " + ((Instruction)((Object)string2)).surroundingDefinition + "\n" : "surroundingDefinition = null\n";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        charSequence = new StringBuilder().append((String)charSequence);
        String string2 = ((Instruction)((Object)string2)).surroundingElements != null ? "surroundingElements = " + ((Instruction)((Object)string2)).surroundingElements.getShapes().length + "\n" : "surroundingElements = null";
        return ((StringBuilder)charSequence).append(string2).toString();
    }
}

