/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Waypoint;

public class Direction {
    public static final String RIGHT = "Right";
    public static final String LEFT = "Left";
    public static final String FORWARD = "Forward";
    public static final String UTURN = "UTurn";
    public static final String ARRIVE = "Arrive";
    private int threshold;
    private String value;
    private Waypoint a;
    private Waypoint b;
    private Waypoint c;
    private float angle;

    public Direction(@NonNull Waypoint waypoint, @Nullable Waypoint waypoint2, @Nullable Waypoint waypoint3) {
        this(waypoint, waypoint2, waypoint3, 20);
    }

    public Direction(@NonNull Waypoint waypoint, @Nullable Waypoint waypoint2, @Nullable Waypoint waypoint3, @NonNull int n) {
        this.a = waypoint;
        this.b = waypoint2;
        this.c = waypoint3;
        this.threshold = n;
        if (this.c != null) {
            this.angle = Direction.getAngle(waypoint2, waypoint3) - Direction.getAngle(waypoint, waypoint2);
            this.value = this.getValue();
        } else {
            this.value = ARRIVE;
        }
    }

    public static float getAngle(@NonNull Waypoint doubleArray, @NonNull Waypoint doubleArray2) {
        if (doubleArray != null && doubleArray.getCoordinates() != null) {
            if (doubleArray2 != null && doubleArray2.getCoordinates() != null) {
                double d;
                doubleArray = doubleArray.getCoordinates();
                doubleArray2 = doubleArray2.getCoordinates();
                double d2 = Math.toDegrees(Math.atan2(doubleArray2[1].floatValue() - doubleArray[1].floatValue(), doubleArray2[0].floatValue() - doubleArray[0].floatValue()));
                if (d < 0.0) {
                    d2 += 360.0;
                }
                return (float)d2;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public static float getAngle(@NonNull PointF pointF, @NonNull PointF pointF2) {
        double d;
        double d2 = Math.toDegrees(Math.atan2(pointF2.y - pointF.y, pointF2.x - pointF.x));
        if (d < 0.0) {
            d2 += 360.0;
        }
        return (float)d2;
    }

    public String getValue() {
        int n;
        float f;
        block10: {
            block9: {
                int n2;
                float f2;
                int n3;
                block8: {
                    block7: {
                        float f3;
                        int n4;
                        float f4;
                        f = this.angle;
                        n3 = this.threshold;
                        if (f4 > (float)n4 && f < (float)(180 - n3)) break block7;
                        f = this.angle;
                        n3 = this.threshold;
                        if (!(f3 < (float)(-180 - n3))) break block8;
                    }
                    return RIGHT;
                }
                if (f < (float)(0 - n3) && f > (float)(n3 + -180)) break block9;
                f = this.angle;
                n = this.threshold;
                if (!(f2 > (float)(n2 + 180))) break block10;
            }
            return LEFT;
        }
        if (f >= (float)(0 - n) && f <= (float)n) {
            return FORWARD;
        }
        return UTURN;
    }

    public void setValue(@NonNull String string) {
        this.value = string;
    }

    public Waypoint getA() {
        return this.a;
    }

    public void setA(@NonNull Waypoint waypoint) {
        this.a = waypoint;
    }

    public Waypoint getB() {
        return this.b;
    }

    public void setB(@NonNull Waypoint waypoint) {
        this.b = waypoint;
    }

    public Waypoint getC() {
        return this.c;
    }

    public void setC(@Nullable Waypoint waypoint) {
        this.c = waypoint;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }
}

