/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Waypoint;

public class Direction {
    private int threshold;
    public static final String RIGHT = "Right";
    public static final String LEFT = "Left";
    public static final String FORWARD = "Forward";
    public static final String UTURN = "UTurn";
    public static final String ARRIVE = "Arrive";
    private String value;
    private Waypoint a;
    private Waypoint b;
    private Waypoint c;
    private float angle;

    public Direction(@NonNull Waypoint waypoint, @Nullable Waypoint waypoint2, @Nullable Waypoint waypoint3) {
        this(waypoint, waypoint2, waypoint3, 20);
    }

    public Direction(@NonNull Waypoint waypoint, @Nullable Waypoint waypoint2, @Nullable Waypoint waypoint3, @NonNull int n) {
        this.a = waypoint;
        this.b = waypoint2;
        this.c = waypoint3;
        this.threshold = n;
        if (this.c != null) {
            this.angle = Direction.getAngle(waypoint2, waypoint3) - Direction.getAngle(waypoint, waypoint2);
            this.value = this.getValue();
        } else {
            this.value = ARRIVE;
        }
    }

    public String getValue() {
        if (this.angle > (float)this.threshold && this.angle < (float)(180 - this.threshold) || this.angle < (float)(-180 - this.threshold)) {
            return RIGHT;
        }
        if (this.angle < (float)(0 - this.threshold) && this.angle > (float)(-180 + this.threshold) || this.angle > (float)(180 + this.threshold)) {
            return LEFT;
        }
        if (this.angle >= (float)(0 - this.threshold) && this.angle <= (float)this.threshold) {
            return FORWARD;
        }
        return UTURN;
    }

    public void setValue(@NonNull String string) {
        this.value = string;
    }

    public static float getAngle(@NonNull Waypoint waypoint, @NonNull Waypoint waypoint2) {
        if (waypoint == null || waypoint.getCoordinates() == null) {
            return 0.0f;
        }
        if (waypoint2 == null || waypoint2.getCoordinates() == null) {
            return 0.0f;
        }
        Float[] floatArray = waypoint.getCoordinates();
        Float[] floatArray2 = waypoint2.getCoordinates();
        double d = Math.atan2(floatArray2[1].floatValue() - floatArray[1].floatValue(), floatArray2[0].floatValue() - floatArray[0].floatValue());
        double d2 = Math.toDegrees(d);
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return (float)d2;
    }

    public static float getAngle(@NonNull PointF pointF, @NonNull PointF pointF2) {
        double d = Math.atan2(pointF2.y - pointF.y, pointF2.x - pointF.x);
        double d2 = Math.toDegrees(d);
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return (float)d2;
    }

    public Waypoint getA() {
        return this.a;
    }

    public void setA(@NonNull Waypoint waypoint) {
        this.a = waypoint;
    }

    public Waypoint getB() {
        return this.b;
    }

    public void setB(@NonNull Waypoint waypoint) {
        this.b = waypoint;
    }

    public Waypoint getC() {
        return this.c;
    }

    public void setC(@Nullable Waypoint waypoint) {
        this.c = waypoint;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }
}

