/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.astar.ASNode;
import com.jibestream.jmapandroidsdk.astar.PathPerFloor;
import com.jibestream.jmapandroidsdk.collections.MapCollection;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.main.Utilities;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JIconDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JShapeDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.UserLocation;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import com.jibestream.navigationkit.NavDirectionPopupDrawable;
import com.jibestream.navigationkit.NavigationKitOptions;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.instructionfactory.Instruction;
import com.jibestream.navigationkit.instructionfactory.InstructionFactory;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;
import com.jibestream.navigationkit.surroundings.SurroundingIcon;
import com.jibestream.navigationkit.surroundings.SurroundingItem;
import com.jibestream.navigationkit.surroundings.SurroundingShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class NavigationKit {
    private JController controller;
    private int angleThreshold = 20;
    private InstructionFactory instructionFactory;

    public NavigationKit(@NonNull JController jController) {
        this.controller = jController;
        this.instructionFactory = new InstructionFactory(this, jController);
        this.instructionFactory.addLayerOfInterest("Units");
    }

    public NavigationKit(@NonNull JController jController, @Nullable NavigationKitOptions navigationKitOptions) {
        this.controller = jController;
        if (navigationKitOptions == null) {
            new NavigationKit(jController);
            return;
        }
        this.instructionFactory = new InstructionFactory(this, jController);
        this.instructionFactory.setVisualLimitLeft(navigationKitOptions.getVisualLimitLeft());
        this.instructionFactory.setVisualLimitRight(navigationKitOptions.getVisualLimitRight());
        this.instructionFactory.setVisualRange(navigationKitOptions.getVisualRange());
        if (navigationKitOptions.getLayersOfInterest().isEmpty()) {
            this.instructionFactory.addLayerOfInterest("Units");
        } else {
            for (String string : navigationKitOptions.getLayersOfInterest()) {
                this.instructionFactory.addLayerOfInterest(string);
            }
        }
        for (String string : navigationKitOptions.getVisualObstacles()) {
            this.instructionFactory.addVisualObstacles(string);
        }
    }

    public void setAngleThreshold(int n) {
        this.angleThreshold = n;
    }

    public Instruction[] createInstructionsFromPaths(@NonNull PathPerFloor[] pathPerFloorArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.controller != null) {
            MapCollection mapCollection = this.controller.getActiveVenue().getMaps();
            int n = 0;
            for (PathPerFloor pathPerFloor : pathPerFloorArray) {
                Map map;
                Instruction instruction;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Map map2 = mapCollection.getById(pathPerFloor.mapId);
                Waypoint waypoint = map2.getWaypoints().getById(pathPerFloor.points[pathPerFloor.points.length - 1].id);
                ASNode[] aSNodeArray = pathPerFloor.points;
                float f = 0.0f;
                for (int i = 0; i < pathPerFloor.points.length; ++i) {
                    object4 = map2.getWaypoints().getById(pathPerFloor.points[i].id);
                    object3 = null;
                    object2 = null;
                    if (i + 1 < aSNodeArray.length) {
                        object3 = map2.getWaypoints().getById(pathPerFloor.points[i + 1].id);
                    }
                    if (i + 2 < aSNodeArray.length) {
                        object2 = map2.getWaypoints().getById(pathPerFloor.points[i + 2].id);
                    }
                    if (object4 == null || object3 == null || object2 == null) continue;
                    object = new Direction((Waypoint)object4, (Waypoint)object3, (Waypoint)object2, this.angleThreshold);
                    if (!((Direction)object).getValue().equalsIgnoreCase("Forward")) {
                        instruction = this.instructionFactory.createFromDirection((Direction)object);
                        instruction.setPixelDistance(f += instruction.getPixelDistance());
                        f = 0.0f;
                        float f2 = this.pointPairToBearingDegrees(new PointF(object4.getCoordinates()[0].floatValue(), object4.getCoordinates()[1].floatValue()), new PointF(object3.getCoordinates()[0].floatValue(), object3.getCoordinates()[1].floatValue()));
                        float f3 = this.pointPairToBearingDegrees(new PointF(object4.getCoordinates()[0].floatValue(), object4.getCoordinates()[1].floatValue()), new PointF(object2.getCoordinates()[0].floatValue(), object2.getCoordinates()[1].floatValue()));
                        instruction.setTurnReferenceAngle(this.getRelativeAngleWithDegrees(f2, f3));
                        arrayList.add(instruction);
                        continue;
                    }
                    f += this.distanceBetweenPoint(new PointF(object4.getCoordinates()[0].floatValue(), object4.getCoordinates()[1].floatValue()), new PointF(object3.getCoordinates()[0].floatValue(), object3.getCoordinates()[1].floatValue()));
                }
                if (n < pathPerFloorArray.length - 1) {
                    map = mapCollection.getById(pathPerFloor.mapId);
                    object4 = mapCollection.getById(pathPerFloorArray[n + 1].mapId);
                    object3 = pathPerFloor.pathType.getName();
                    object2 = this.controller.getCurrentBuilding().getFloors().getByMap(map);
                    object = this.controller.getCurrentBuilding().getFloors().getByMap((Map)object4);
                    instruction = new Instruction();
                    instruction.setDirection(object.getLevel() > object2.getLevel() ? "up" : "down");
                    instruction.setText("Take the " + (String)object3 + " " + instruction.getDirection() + " to " + object.getName());
                    instruction.setCompletionPoint(waypoint);
                    instruction.setPathType(pathPerFloor.pathType);
                    instruction.setNextFloor((Floor)object);
                    arrayList.add(instruction);
                } else if (aSNodeArray.length < 2) {
                    map = map2.getWaypoints().getById(aSNodeArray[0].id);
                    object4 = new Direction((Waypoint)map, null, null, this.angleThreshold);
                    object3 = this.instructionFactory.createFromDirection((Direction)object4);
                    ((Instruction)object3).setTurnReferenceAngle(0.0f);
                    ((Instruction)object3).setPixelDistance(0.0f);
                    arrayList.add(object3);
                } else {
                    map = map2.getWaypoints().getById(aSNodeArray[aSNodeArray.length - 2].id);
                    object4 = waypoint;
                    object3 = new Direction((Waypoint)map, (Waypoint)object4, null, this.angleThreshold);
                    object2 = this.instructionFactory.createFromDirection((Direction)object3);
                    ((Instruction)object2).setTurnReferenceAngle(Direction.getAngle((Waypoint)map, object4));
                    ((Instruction)object2).setPixelDistance(f);
                    arrayList.add(object2);
                }
                ++n;
            }
        }
        return arrayList.toArray(new Instruction[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public SurroundingElements getSurroundingElements(@NonNull SurroundingDefinition surroundingDefinition) {
        ArrayList arrayList;
        PointF pointF;
        Object object;
        Object arrayList11;
        Object object22;
        float f = surroundingDefinition.getGazeDirection() - (float)surroundingDefinition.getVisualLimitLeft();
        float f2 = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float f3 = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float f4 = surroundingDefinition.getGazeDirection() + (float)surroundingDefinition.getVisualLimitRight();
        float f5 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), new PointF(f2, f3));
        SurroundingElements surroundingElements = new SurroundingElements();
        PointF pointF2 = surroundingDefinition.getPoint();
        float f6 = surroundingDefinition.getVisualRange();
        HashMap<String, ArrayList<ArrayList>> hashMap = new HashMap<String, ArrayList<ArrayList>>();
        HashMap<ArrayList, JShapeDrawable> hashMap2 = new HashMap<ArrayList, JShapeDrawable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(surroundingDefinition.getLayersOfInterest());
        arrayList2.addAll(surroundingDefinition.getVisualObstacles());
        ArrayList<PointF> arrayList3 = new ArrayList<PointF>();
        for (String object42 : arrayList2) {
            JShapeDrawable[] jShapeDrawableArray = this.controller.getShapesInLayer(object42, surroundingDefinition.getMap());
            float f7 = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)f * Math.PI / 180.0));
            float f8 = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)f * Math.PI / 180.0));
            float f9 = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)f4 * Math.PI / 180.0));
            float f10 = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)f4 * Math.PI / 180.0));
            object22 = new Path();
            arrayList11 = new PointF(surroundingDefinition.getPoint().x, surroundingDefinition.getPoint().y);
            object22.moveTo(((PointF)arrayList11).x, ((PointF)arrayList11).y);
            arrayList11 = new PointF(f7, f8);
            object22.lineTo(((PointF)arrayList11).x, ((PointF)arrayList11).y);
            arrayList11 = new PointF(f2, f3);
            object22.lineTo(((PointF)arrayList11).x, ((PointF)arrayList11).y);
            arrayList11 = new PointF(f9, f10);
            object22.lineTo(((PointF)arrayList11).x, ((PointF)arrayList11).y);
            object22.close();
            if (arrayList3.size() < 1) {
                arrayList3.add(surroundingDefinition.getPoint());
                arrayList3.add(new PointF(f7, f8));
                arrayList3.add(new PointF(f2, f3));
                arrayList3.add(new PointF(f9, f10));
            }
            RectF pointF8 = new RectF();
            object22.computeBounds(pointF8, true);
            for (JShapeDrawable jShapeDrawable : jShapeDrawableArray) {
                if (!jShapeDrawable.getBounds().intersect(pointF8)) continue;
                ArrayList arrayList4 = jShapeDrawable.getSegments();
                for (ArrayList arrayList5 : arrayList4) {
                    object = (PointF)arrayList5.get(0);
                    boolean bl = this.doesSegmentWithPoint((PointF)object, pointF = (PointF)arrayList5.get(arrayList5.size() - 1), pointF2, f6);
                    if (!bl) continue;
                    if (jShapeDrawable.getClassName().equalsIgnoreCase(object42) && surroundingDefinition.getLayersOfInterest().contains(jShapeDrawable.getClassName())) {
                        arrayList = (ArrayList)hashMap.get(object42);
                        if (arrayList != null) {
                            arrayList.add(arrayList5);
                        } else {
                            arrayList = new ArrayList();
                        }
                        hashMap.put(object42, arrayList);
                        hashMap2.put(arrayList5, jShapeDrawable);
                        continue;
                    }
                    arrayList = (ArrayList)hashMap.get("Obstacles");
                    if (arrayList != null) {
                        arrayList.add(arrayList5);
                    } else {
                        arrayList = new ArrayList();
                    }
                    hashMap.put("Obstacles", arrayList);
                }
            }
        }
        ArrayList arrayList6 = new ArrayList();
        Object var15_16 = null;
        float f11 = Float.MAX_VALUE;
        ArrayList<PointF> arrayList7 = new ArrayList<PointF>();
        arrayList7.add(surroundingDefinition.getPoint());
        arrayList7.add(new PointF(f2, f3));
        for (String string : hashMap.keySet()) {
            for (Object object22 : (ArrayList)hashMap.get(string)) {
                float f12;
                arrayList11 = this.getIntersectionWithRay(arrayList7, (ArrayList<PointF>)object22);
                if (arrayList11 == null || !((f12 = this.distanceBetweenPoint((PointF)arrayList11, surroundingDefinition.getPoint())) < f11)) continue;
                f11 = f12;
                PointF pointF3 = object22;
            }
        }
        Path path = new Path();
        path.moveTo(surroundingDefinition.getPoint().x, surroundingDefinition.getPoint().y);
        path.lineTo(f2, f3);
        ArrayList<Object> arrayList8 = new ArrayList<Object>();
        for (Object object22 : hashMap.keySet()) {
            block6: for (ArrayList arrayList9 : (ArrayList)hashMap.get(object22)) {
                float f13;
                float f14;
                void var15_17;
                JShapeDrawable jShapeDrawable = (JShapeDrawable)hashMap2.get(arrayList9);
                Boolean bl = false;
                for (SurroundingShape surroundingShape : arrayList8) {
                    if (surroundingShape.getShape() != jShapeDrawable) continue;
                    bl = true;
                    break;
                }
                if (bl.booleanValue()) continue;
                if (var15_17 != null && var15_17.equals(arrayList9)) {
                    arrayList6.add(arrayList9);
                    if (jShapeDrawable == null) continue;
                    SurroundingShape surroundingShape = new SurroundingShape();
                    surroundingShape.setShape(jShapeDrawable);
                    surroundingShape.setLayerName(jShapeDrawable.getClassName());
                    PointF pointF4 = new PointF();
                    f14 = this.distanceToSegment(surroundingDefinition.getPoint(), arrayList9, pointF4);
                    surroundingShape.setDistance(f14);
                    f13 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), pointF4);
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(f5, f13));
                    arrayList8.add(surroundingShape);
                    continue;
                }
                boolean bl2 = false;
                float f15 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)arrayList9.get(0));
                f14 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)arrayList9.get(arrayList9.size() - 1));
                f13 = this.getRelativeAngleWithDegrees(f5, f15);
                float f16 = this.getRelativeAngleWithDegrees(f5, f14);
                if (f13 < 0.0f && Math.abs(f13) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    bl2 = true;
                }
                if (f13 > 0.0f && Math.abs(f13) < (float)surroundingDefinition.getVisualLimitRight()) {
                    bl2 = true;
                }
                if (f16 < 0.0f && Math.abs(f16) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    bl2 = true;
                }
                if (f16 > 0.0f && Math.abs(f16) < (float)surroundingDefinition.getVisualLimitRight()) {
                    bl2 = true;
                }
                if (!bl2) continue;
                object = arrayList9.iterator();
                block8: while (object.hasNext()) {
                    Object object32;
                    PointF pointF5 = pointF = (PointF)object.next();
                    arrayList = new ArrayList();
                    arrayList.add(surroundingDefinition.getPoint());
                    arrayList.add(pointF);
                    boolean bl3 = true;
                    for (Object object32 : hashMap.keySet()) {
                        for (ArrayList arrayList10 : (ArrayList)hashMap.get(object32)) {
                            PointF pointF6;
                            PointF pointF7;
                            PointF pointF8;
                            if (arrayList10 == arrayList9 || (pointF8 = this.getIntersectionWithRay(arrayList, arrayList10)) == null || (pointF7 = new PointF((float)Math.ceil(pointF8.x), (float)Math.ceil(pointF8.y))).equals((Object)(pointF6 = new PointF((float)Math.ceil(pointF5.x), (float)Math.ceil(pointF5.y))))) continue;
                            bl3 = false;
                            break;
                        }
                        if (bl3) continue;
                        break;
                    }
                    if (!bl3) continue;
                    arrayList6.add(arrayList9);
                    if (jShapeDrawable == null) continue block6;
                    for (Object object32 : arrayList8) {
                        if (((SurroundingShape)object32).getShape() != jShapeDrawable) continue;
                        continue block8;
                    }
                    SurroundingShape surroundingShape = new SurroundingShape();
                    surroundingShape.setShape(jShapeDrawable);
                    surroundingShape.setLayerName(jShapeDrawable.getClassName());
                    object32 = new PointF();
                    float f17 = this.distanceToSegment(surroundingDefinition.getPoint(), arrayList9, (PointF)object32);
                    surroundingShape.setDistance(f17);
                    float f18 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)object32);
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(f5, f18));
                    arrayList8.add(surroundingShape);
                    continue block6;
                }
            }
        }
        Collections.sort(arrayList8, new Comparator<SurroundingShape>(){

            @Override
            public int compare(SurroundingShape surroundingShape, SurroundingShape surroundingShape2) {
                Float f = Float.valueOf(surroundingShape.getDistance());
                Float f2 = Float.valueOf(surroundingShape2.getDistance());
                return f.compareTo(f2);
            }
        });
        surroundingElements.setShapes(arrayList8.toArray(new SurroundingShape[arrayList8.size()]));
        Path path2 = new Path();
        if (arrayList3.size() > 0) {
            object22 = (PointF)arrayList3.get(0);
            path2.moveTo(object22.x, object22.y);
            for (int i = 1; i < arrayList3.size(); ++i) {
                PointF pointF9 = (PointF)arrayList3.get(i);
                path2.lineTo(pointF9.x, pointF9.y);
            }
            path2.close();
        }
        object22 = new ArrayList();
        ArrayList arrayList12 = new ArrayList();
        for (String string : surroundingDefinition.getLayersOfInterest()) {
            ArrayList<JIconDrawable> arrayList13 = new ArrayList<JIconDrawable>();
            MapLayer mapLayer = this.controller.getMapView().getCurrentMapDrawable().getMapLayer(string);
            if (mapLayer != null) {
                arrayList13.addAll(new ArrayList<JIconDrawable>(Arrays.asList(mapLayer.getIconDrawables())));
            }
            arrayList12.addAll(arrayList13);
        }
        for (JIconDrawable jIconDrawable : arrayList12) {
            Waypoint waypoint = surroundingDefinition.getMap().getWaypoints().getById(jIconDrawable.getWaypointId());
            if (waypoint == null) continue;
            PointF pointF10 = new PointF(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue());
            RectF rectF = new RectF();
            path2.computeBounds(rectF, true);
            Region region = new Region();
            region.setPath(path2, new Region((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom));
            if (!region.contains((int)pointF10.x, (int)pointF10.y)) continue;
            boolean bl = true;
            ArrayList<PointF> arrayList14 = new ArrayList<PointF>();
            arrayList14.add(surroundingDefinition.getPoint());
            arrayList14.add(pointF10);
            object = arrayList6.iterator();
            while (object.hasNext()) {
                ArrayList arrayList15 = (ArrayList)object.next();
                PointF pointF11 = this.getIntersectionWithRay(arrayList14, arrayList15);
                if (pointF11 == null) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object = new SurroundingIcon();
            ((SurroundingIcon)object).setIcon(jIconDrawable);
            ((SurroundingItem)object).setLayerName(jIconDrawable.getClassName());
            float f19 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), pointF10);
            f5 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), new PointF(f2, f3));
            ((SurroundingItem)object).setAngle(this.getRelativeAngleWithDegrees(f5, f19));
            ((SurroundingItem)object).setDistance(this.distanceBetweenPoint(surroundingDefinition.getPoint(), pointF10));
            object22.add(object);
        }
        Collections.sort(object22, new Comparator<SurroundingIcon>(){

            @Override
            public int compare(SurroundingIcon surroundingIcon, SurroundingIcon surroundingIcon2) {
                Float f = Float.valueOf(surroundingIcon.getDistance());
                Float f2 = Float.valueOf(surroundingIcon2.getDistance());
                return f.compareTo(f2);
            }
        });
        surroundingElements.setIcons(object22.toArray(new SurroundingIcon[object22.size()]));
        return surroundingElements;
    }

    public void drawPathWithInstructions(@NonNull PathPerFloor[] pathPerFloorArray, @Nullable JStyle jStyle, @Nullable JStyle jStyle2, @Nullable JStyle jStyle3) {
        Instruction[] instructionArray;
        for (Instruction instruction : instructionArray = this.createInstructionsFromPaths(pathPerFloorArray)) {
            Map map;
            Waypoint waypoint;
            NavDirectionPopupDrawable navDirectionPopupDrawable = new NavDirectionPopupDrawable(instruction.getText().toLowerCase().contains("arrive") ? "ARRIVE" : instruction.getDirection().toUpperCase(), jStyle2, jStyle3);
            Waypoint waypoint2 = waypoint = instruction.getDecisionPoint() != null ? instruction.getDecisionPoint() : instruction.getCompletionPoint();
            if (waypoint == null || (map = this.controller.getActiveVenue().getMaps().getById(waypoint.getMapId())) == null) continue;
            this.controller.addComponent((JDrawable)navDirectionPopupDrawable, map, waypoint, "Wayfind-Layer");
        }
        this.controller.drawWayfindingPath(pathPerFloorArray, jStyle);
    }

    public void setInstructionFactory(@NonNull InstructionFactory instructionFactory) {
        this.instructionFactory = instructionFactory;
    }

    public boolean hasUserVeeredOffRoute(@NonNull PathPerFloor[] pathPerFloorArray, float f) {
        UserLocation userLocation = UserLocation.getInstance();
        for (PathPerFloor pathPerFloor : pathPerFloorArray) {
            if (userLocation.getMapId() != pathPerFloor.mapId || pathPerFloor.points.length < 2) continue;
            PointF pointF = new PointF(userLocation.getX(), userLocation.getY());
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (int i = 0; i < pathPerFloor.points.length - 1; ++i) {
                float f2 = Utilities.distanceFromPointToLine((PointF)pointF, (PointF)pathPerFloor.points[i].asPointF(), (PointF)pathPerFloor.points[i + 1].asPointF());
                arrayList.add(Float.valueOf(f2));
            }
            return ((Float)Collections.min(arrayList)).floatValue() * this.controller.getCurrentMap().getMmPerPixel() > f;
        }
        return false;
    }

    private boolean doesSegmentWithPoint(PointF pointF, PointF pointF2, PointF pointF3, float f) {
        float f2;
        boolean bl = this.circleWithCenter(pointF3, f, pointF);
        boolean bl2 = this.circleWithCenter(pointF3, f, pointF2);
        if (bl || bl2) {
            return true;
        }
        PointF pointF4 = new PointF(pointF2.x - pointF.x, pointF2.y - pointF.y);
        PointF pointF5 = new PointF(pointF.x - pointF3.x, pointF.y - pointF3.y);
        float f3 = this.dotProductOfPoint(pointF4, pointF4);
        float f4 = 2.0f * this.dotProductOfPoint(pointF5, pointF4);
        float f5 = f4 * f4 - 4.0f * f3 * (f2 = this.dotProductOfPoint(pointF5, pointF5) - f * f);
        if (f5 < 0.0f) {
            return false;
        }
        f5 = (float)Math.sqrt(f5);
        float f6 = (-f4 - f5) / (2.0f * f3);
        float f7 = (-f4 + f5) / (2.0f * f3);
        if (f6 >= 0.0f && f6 <= 1.0f) {
            return true;
        }
        return f7 >= 0.0f && f7 <= 1.0f;
    }

    private boolean circleWithCenter(PointF pointF, float f, PointF pointF2) {
        float f2 = (float)Math.sqrt((pointF2.x - pointF.x) * (pointF2.x - pointF.x) + (pointF2.y - pointF.y) * (pointF2.y - pointF.y));
        return f2 <= f;
    }

    private float dotProductOfPoint(PointF pointF, PointF pointF2) {
        return pointF.x * pointF2.x + pointF.y * pointF2.y;
    }

    private PointF getIntersectionWithRay(ArrayList<PointF> arrayList, ArrayList<PointF> arrayList2) {
        PointF pointF = arrayList.get(0);
        PointF pointF2 = arrayList.get(arrayList.size() - 1);
        float f = pointF.x;
        float f2 = pointF.y;
        float f3 = pointF2.x;
        float f4 = pointF2.y;
        PointF pointF3 = new PointF(f, f2);
        PointF pointF4 = new PointF(f3, f4);
        PointF pointF5 = arrayList2.get(0);
        PointF pointF6 = arrayList2.get(arrayList2.size() - 1);
        float f5 = pointF5.x;
        float f6 = pointF5.y;
        float f7 = pointF6.x;
        float f8 = pointF6.y;
        PointF pointF7 = new PointF(f5, f6);
        PointF pointF8 = new PointF(f7, f8);
        float f9 = (pointF4.x - pointF3.x) * (pointF8.y - pointF7.y) - (pointF4.y - pointF3.y) * (pointF8.x - pointF7.x);
        if (f9 == 0.0f) {
            return null;
        }
        float f10 = ((pointF7.x - pointF3.x) * (pointF8.y - pointF7.y) - (pointF7.y - pointF3.y) * (pointF8.x - pointF7.x)) / f9;
        float f11 = ((pointF7.x - pointF3.x) * (pointF4.y - pointF3.y) - (pointF7.y - pointF3.y) * (pointF4.x - pointF3.x)) / f9;
        if ((double)f10 < 0.0 || (double)f10 > 1.0) {
            return null;
        }
        if ((double)f11 < 0.0 || (double)f11 > 1.0) {
            return null;
        }
        PointF pointF9 = new PointF(pointF3.x + f10 * (pointF4.x - pointF3.x), pointF3.y + f10 * (pointF4.y - pointF3.y));
        return pointF9;
    }

    private float distanceBetweenPoint(PointF pointF, PointF pointF2) {
        float f = pointF2.x - pointF.x;
        float f2 = pointF2.y - pointF.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        return f3;
    }

    private float pointPairToBearingDegrees(PointF pointF, PointF pointF2) {
        PointF pointF3 = new PointF(pointF2.x - pointF.x, pointF2.y - pointF.y);
        double d = pointF3.y < 0.0f ? Math.atan2(-pointF3.y, pointF3.x) : Math.atan2(pointF3.y, -pointF3.x) + Math.PI;
        return (float)(d * 57.29577951308232);
    }

    private float getRelativeAngleWithDegrees(float f, float f2) {
        if (Math.abs(f2 - f) > 180.0f) {
            if (f2 > f) {
                return (float)Math.abs(360.0 - (double)f2 + (double)f);
            }
            if (f2 < f) {
                return -Math.abs(360.0f - f + f2);
            }
        } else {
            if (f2 > f) {
                return -(f2 - f);
            }
            if (f2 < f) {
                return f - f2;
            }
        }
        return 0.0f;
    }

    private float getPixelsFromInches(float f) {
        return this.getPixelsFromMillimeters((float)((double)f * 25.4));
    }

    private float getPixelsFromMillimeters(float f) {
        return f / this.controller.getCurrentMap().getMmPerPixel();
    }

    private float distanceToSegment(PointF pointF, ArrayList<PointF> arrayList, PointF pointF2) {
        PointF pointF3;
        PointF pointF4 = arrayList.get(0);
        float f = this.distanceBetweenPoint(pointF4, pointF3 = arrayList.get(arrayList.size() - 1));
        if (f == 0.0f) {
            pointF2.set(pointF3.x, pointF3.y);
            return this.distanceBetweenPoint(pointF, pointF3);
        }
        float f2 = ((pointF.x - pointF4.x) * (pointF3.x - pointF4.x) + (pointF.y - pointF4.y) * (pointF3.y - pointF4.y)) / f;
        if (f2 < 0.0f) {
            pointF2.set(pointF4.x, pointF4.y);
            return this.distanceBetweenPoint(pointF, pointF4);
        }
        if (f2 > 1.0f) {
            pointF2.set(pointF3.x, pointF3.y);
            return this.distanceBetweenPoint(pointF, pointF3);
        }
        pointF2 = new PointF(pointF4.x + f2 * (pointF3.x - pointF4.x), pointF4.y + f2 * (pointF3.y - pointF4.y));
        return (float)Math.sqrt(this.distanceBetweenPoint(pointF, pointF2));
    }
}

