/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;

public class Instruction {
    private String direction;
    private String text;
    private String defaultInstruction;
    private float turnReferenceAngle;
    private float pixelDistance;
    private PathType pathType;
    private Waypoint originPoint;
    private Waypoint decisionPoint;
    private Waypoint completionPoint;
    private Floor nextFloor;
    private SurroundingDefinition surroundingDefinition;
    private SurroundingElements surroundingElements;

    public Instruction() {
    }

    public Instruction(@NonNull Direction direction) {
        this.setDistanceWithDirection(direction);
        this.setPointsWithDirection(direction);
        this.setTextWithDirection(direction);
    }

    public void setDistanceWithDirection(@NonNull Direction direction) {
        if (direction == null || direction.getA() == null || direction.getB() == null) {
            return;
        }
        Float[] aCoords = direction.getA().getCoordinates();
        Float[] bCoords = direction.getB().getCoordinates();
        if (aCoords.length > 0 && bCoords.length > 0) {
            this.pixelDistance = Math.round(Math.sqrt(Math.pow(bCoords[0].floatValue() - aCoords[0].floatValue(), 2.0) + Math.pow(bCoords[1].floatValue() - aCoords[1].floatValue(), 2.0)));
        }
    }

    public void setPointsWithDirection(@NonNull Direction direction) {
        this.originPoint = direction.getA();
        this.decisionPoint = direction.getC() != null ? direction.getB() : null;
        this.completionPoint = direction.getC() != null ? direction.getC() : direction.getB();
    }

    public void setTextWithDirection(@NonNull Direction direction) {
        this.direction = direction.getValue();
        this.text = direction.getC() != null ? "Turn " + direction.getValue() : "Arrive at your destination";
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(@NonNull String direction) {
        this.direction = direction;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NonNull String text) {
        this.text = text;
    }

    public String getDefaultInstruction() {
        return this.defaultInstruction;
    }

    public void setDefaultInstruction(@NonNull String defaultInstruction) {
        this.defaultInstruction = defaultInstruction;
    }

    public float getTurnReferenceAngle() {
        return this.turnReferenceAngle;
    }

    public void setTurnReferenceAngle(float turnReferenceAngle) {
        this.turnReferenceAngle = turnReferenceAngle;
    }

    public float getPixelDistance() {
        return this.pixelDistance;
    }

    public void setPixelDistance(float pixelDistance) {
        this.pixelDistance = pixelDistance;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(@Nullable PathType pathType) {
        this.pathType = pathType;
    }

    public Waypoint getOriginPoint() {
        return this.originPoint;
    }

    public void setOriginPoint(@NonNull Waypoint originPoint) {
        this.originPoint = originPoint;
    }

    public Waypoint getDecisionPoint() {
        return this.decisionPoint;
    }

    public void setDecisionPoint(@Nullable Waypoint decisionPoint) {
        this.decisionPoint = decisionPoint;
    }

    public Waypoint getCompletionPoint() {
        return this.completionPoint;
    }

    public void setCompletionPoint(@NonNull Waypoint completionPoint) {
        this.completionPoint = completionPoint;
    }

    public Floor getNextFloor() {
        return this.nextFloor;
    }

    public void setNextFloor(@Nullable Floor nextFloor) {
        this.nextFloor = nextFloor;
    }

    public SurroundingDefinition getSurroundingDefinition() {
        return this.surroundingDefinition;
    }

    public void setSurroundingDefinition(@NonNull SurroundingDefinition surroundingDefinition) {
        this.surroundingDefinition = surroundingDefinition;
    }

    public SurroundingElements getSurroundingElements() {
        return this.surroundingElements;
    }

    public void setSurroundingElements(@NonNull SurroundingElements surroundingElements) {
        this.surroundingElements = surroundingElements;
    }

    public String toString() {
        String instructionString = "";
        instructionString = instructionString + (this.direction != null ? "direction = " + this.direction + "\n" : "");
        instructionString = instructionString + (this.text != null ? "text = " + this.text + "\n" : "");
        instructionString = instructionString + (this.defaultInstruction != null ? "defaultInstruction = " + this.defaultInstruction + "\n" : "");
        instructionString = instructionString + "turnReferenceAngle = " + this.turnReferenceAngle + "\n";
        instructionString = instructionString + "pixelDistance = " + this.pixelDistance + "\n";
        instructionString = instructionString + (this.pathType != null ? "pathType = " + this.pathType.toString() + "\n" : "");
        instructionString = instructionString + (this.originPoint != null ? "originPoint = " + this.originPoint + "\n" : "originPoint = null\n");
        instructionString = instructionString + (this.decisionPoint != null ? "decisionPoint = " + this.decisionPoint + "\n" : "decisionPoint = null\n");
        instructionString = instructionString + (this.completionPoint != null ? "completionPoint = " + this.completionPoint + "\n" : "completionPoint = null\n");
        instructionString = instructionString + (this.nextFloor != null ? "nextFloor = " + this.nextFloor + "\n" : "");
        instructionString = instructionString + (this.surroundingDefinition != null ? "surroundingDefinition = " + this.surroundingDefinition + "\n" : "surroundingDefinition = null\n");
        instructionString = instructionString + (this.surroundingElements != null ? "surroundingElements = " + this.surroundingElements.getShapes().length + "\n" : "surroundingElements = null");
        return instructionString;
    }
}

