/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.components.Waypoint;

public class Direction {
    private int threshold;
    public static final String RIGHT = "Right";
    public static final String LEFT = "Left";
    public static final String FORWARD = "Forward";
    public static final String UTURN = "UTurn";
    public static final String ARRIVE = "Arrive";
    private String value;
    private Waypoint a;
    private Waypoint b;
    private Waypoint c;
    private float angle;

    public Direction(@NonNull Waypoint a, @Nullable Waypoint b, @Nullable Waypoint c) {
        this(a, b, c, 20);
    }

    public Direction(@NonNull Waypoint a, @Nullable Waypoint b, @Nullable Waypoint c, @NonNull int threshold) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.threshold = threshold;
        if (this.c != null) {
            this.angle = Direction.getAngle(b, c) - Direction.getAngle(a, b);
            this.value = this.getValue();
        } else {
            this.value = ARRIVE;
        }
    }

    public String getValue() {
        if (this.angle > (float)this.threshold && this.angle < (float)(180 - this.threshold) || this.angle < (float)(-180 - this.threshold)) {
            return RIGHT;
        }
        if (this.angle < (float)(0 - this.threshold) && this.angle > (float)(-180 + this.threshold) || this.angle > (float)(180 + this.threshold)) {
            return LEFT;
        }
        if (this.angle >= (float)(0 - this.threshold) && this.angle <= (float)this.threshold) {
            return FORWARD;
        }
        return UTURN;
    }

    public void setValue(@NonNull String value) {
        this.value = value;
    }

    public static float getAngle(@NonNull Waypoint startingWaypoint, @NonNull Waypoint targetWaypoint) {
        if (startingWaypoint == null || startingWaypoint.getCoordinates() == null) {
            return 0.0f;
        }
        if (targetWaypoint == null || targetWaypoint.getCoordinates() == null) {
            return 0.0f;
        }
        Float[] startingCoords = startingWaypoint.getCoordinates();
        Float[] targetCoords = targetWaypoint.getCoordinates();
        double theta = Math.atan2(targetCoords[1].floatValue() - startingCoords[1].floatValue(), targetCoords[0].floatValue() - startingCoords[0].floatValue());
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    public static float getAngle(@NonNull PointF startingPoint, @NonNull PointF targetPoint) {
        double theta = Math.atan2(targetPoint.y - startingPoint.y, targetPoint.x - startingPoint.x);
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    public Waypoint getA() {
        return this.a;
    }

    public void setA(@NonNull Waypoint a) {
        this.a = a;
    }

    public Waypoint getB() {
        return this.b;
    }

    public void setB(@NonNull Waypoint b) {
        this.b = b;
    }

    public Waypoint getC() {
        return this.c;
    }

    public void setC(@Nullable Waypoint c) {
        this.c = c;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

