package com.jibestream.navigationkit;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;

import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.styles.JStyle;

/**
 * Created by jibestream on 2017-11-21.
 */

class NavDirectionPopupDrawable extends JDrawable{
    private final float STROKE_WIDTH = 0.5f;
    private final int BOX_PADDING = 2;
    private final float TEXT_SIZE = 5f;
    private final int RECT_CORNER_RADIUS = 3;

    private Paint textPaint;
    private Paint bgPaint;
    private Paint bgPaintStroke;

    private Rect textBounds;
    private RectF box;
    private String text;

    NavDirectionPopupDrawable(String text, JStyle popupStyle, JStyle textStyle) {
        //initialize paint objects
        if (textStyle == null) {
            textPaint = new Paint();
            textPaint.setAntiAlias(true);
            textPaint.setColor(Color.WHITE);
            textPaint.setTextAlign(Paint.Align.CENTER);
            textPaint.setTextSize(TEXT_SIZE);
        } else {
            this.textPaint = textStyle;
            textPaint.setTextAlign(Paint.Align.CENTER);
        }

        if (popupStyle == null) {
            bgPaint = new Paint();
            bgPaint.setAntiAlias(true);
            bgPaint.setColor(Color.RED);

            bgPaintStroke = new Paint();
            bgPaintStroke.setStyle(Paint.Style.STROKE);
            bgPaintStroke.setAntiAlias(true);
            bgPaintStroke.setColor(Color.WHITE);
            bgPaintStroke.setStrokeWidth(STROKE_WIDTH);
        }
        else {
            bgPaint = popupStyle;
            bgPaint.setStyle(Paint.Style.FILL);

            bgPaintStroke = new Paint();
            bgPaintStroke.setStyle(Paint.Style.STROKE);
            bgPaintStroke.setAntiAlias(true);
            bgPaintStroke.setColor(popupStyle.getStrokeColor() != 0 ? popupStyle.getStrokeColor() : Color.TRANSPARENT);
            bgPaintStroke.setStrokeWidth(popupStyle.getStrokeWidth() > 0 ? popupStyle.getStrokeWidth() : 0);
        }

        setText(text);
        setVisible(true);
        setHeadsUp(true);
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawRoundRect(box, RECT_CORNER_RADIUS, RECT_CORNER_RADIUS, bgPaint);
        canvas.drawRoundRect(box, RECT_CORNER_RADIUS, RECT_CORNER_RADIUS, bgPaintStroke);
        canvas.drawText(text, box.centerX(), box.centerY() - 0.5f + (textBounds.height() / 2f), textPaint);
    }

    public void setText(String text) {
        textBounds = new Rect();
        textPaint.getTextBounds(text, 0, text.length(), textBounds);

        calculateBounds();

        this.text = text;
    }

    @Override
    public void setX(float x) {
        super.setX(x);

        calculateBounds();
    }

    @Override
    public void setY(float y) {
        super.setY(y);

        calculateBounds();
    }

    private void calculateBounds() {
        box = new RectF(getX() - (textBounds.width() / 2) - BOX_PADDING,    //left
                getY() - (textBounds.height() / 2) - BOX_PADDING,           //top
                getX() + (textBounds.width() / 2) + BOX_PADDING,            //right
                getY() + (textBounds.height() / 2) + BOX_PADDING);          //bottom
    }
}
