/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jibestream.jmapandroidsdk.astar.ASNode;
import com.jibestream.jmapandroidsdk.astar.PathPerFloor;
import com.jibestream.jmapandroidsdk.collections.MapCollection;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.main.Utilities;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JIconDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JShapeDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.UserLocation;
import com.jibestream.navigationkit.NavigationKitOptions;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.instructionfactory.Instruction;
import com.jibestream.navigationkit.instructionfactory.InstructionFactory;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;
import com.jibestream.navigationkit.surroundings.SurroundingIcon;
import com.jibestream.navigationkit.surroundings.SurroundingShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class NavigationKit {
    private JController controller;
    private int angleThreshold = 20;
    private InstructionFactory instructionFactory;

    public NavigationKit(@NonNull JController controller) {
        this.controller = controller;
        this.instructionFactory = new InstructionFactory(this, controller);
        this.instructionFactory.addLayerOfInterest("Units");
    }

    public NavigationKit(@NonNull JController controller, @Nullable NavigationKitOptions options) {
        this.controller = controller;
        if (options == null) {
            new NavigationKit(controller);
            return;
        }
        this.instructionFactory = new InstructionFactory(this, controller);
        this.instructionFactory.setVisualLimitLeft(options.getVisualLimitLeft());
        this.instructionFactory.setVisualLimitRight(options.getVisualLimitRight());
        this.instructionFactory.setVisualRange(options.getVisualRange());
        if (options.getLayersOfInterest().isEmpty()) {
            this.instructionFactory.addLayerOfInterest("Units");
        } else {
            for (String layer : options.getLayersOfInterest()) {
                this.instructionFactory.addLayerOfInterest(layer);
            }
        }
        for (String layer : options.getVisualObstacles()) {
            this.instructionFactory.addVisualObstacles(layer);
        }
    }

    public void setAngleThreshold(int angleThreshold) {
        this.angleThreshold = angleThreshold;
    }

    public Instruction[] createInstructionsFromPaths(@NonNull PathPerFloor[] pathPerFloors) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (this.controller != null) {
            MapCollection mapCollection = this.controller.getActiveVenue().getMaps();
            int i = 0;
            for (PathPerFloor pathPerFloor : pathPerFloors) {
                Waypoint a;
                Instruction instruction;
                Map map = mapCollection.getById(pathPerFloor.mapId);
                Waypoint lastWaypoint = map.getWaypoints().getById(pathPerFloor.points[pathPerFloor.points.length - 1].id);
                ASNode[] points = pathPerFloor.points;
                float distanceCalculation = 0.0f;
                for (int k = 0; k < pathPerFloor.points.length; ++k) {
                    Waypoint a2 = map.getWaypoints().getById(pathPerFloor.points[k].id);
                    Waypoint b = null;
                    Waypoint c = null;
                    if (k + 1 < points.length) {
                        b = map.getWaypoints().getById(pathPerFloor.points[k + 1].id);
                    }
                    if (k + 2 < points.length) {
                        c = map.getWaypoints().getById(pathPerFloor.points[k + 2].id);
                    }
                    if (a2 == null || b == null || c == null) continue;
                    Direction direction = new Direction(a2, b, c, this.angleThreshold);
                    if (!direction.getValue().equalsIgnoreCase("Forward")) {
                        instruction = this.instructionFactory.createFromDirection(direction);
                        instruction.setPixelDistance(distanceCalculation += instruction.getPixelDistance());
                        distanceCalculation = 0.0f;
                        float abAngle = this.pointPairToBearingDegrees(new PointF(a2.getCoordinates()[0].floatValue(), a2.getCoordinates()[1].floatValue()), new PointF(b.getCoordinates()[0].floatValue(), b.getCoordinates()[1].floatValue()));
                        float acAngle = this.pointPairToBearingDegrees(new PointF(a2.getCoordinates()[0].floatValue(), a2.getCoordinates()[1].floatValue()), new PointF(c.getCoordinates()[0].floatValue(), c.getCoordinates()[1].floatValue()));
                        instruction.setTurnReferenceAngle(this.getRelativeAngleWithDegrees(abAngle, acAngle));
                        instructions.add(instruction);
                        continue;
                    }
                    distanceCalculation += this.distanceBetweenPoint(new PointF(a2.getCoordinates()[0].floatValue(), a2.getCoordinates()[1].floatValue()), new PointF(b.getCoordinates()[0].floatValue(), b.getCoordinates()[1].floatValue()));
                }
                if (i < pathPerFloors.length - 1) {
                    Map currentMap = mapCollection.getById(pathPerFloor.mapId);
                    Map nextMap = mapCollection.getById(pathPerFloors[i + 1].mapId);
                    String type = pathPerFloor.pathType.getName();
                    Floor currentFloor = this.controller.getCurrentBuilding().getFloors().getByMap(currentMap);
                    Floor nextFloor = this.controller.getCurrentBuilding().getFloors().getByMap(nextMap);
                    instruction = new Instruction();
                    instruction.setDirection(nextFloor.getLevel() > currentFloor.getLevel() ? "up" : "down");
                    instruction.setText("Take the " + type + " " + instruction.getDirection() + " to " + nextFloor.getName());
                    instruction.setCompletionPoint(lastWaypoint);
                    instruction.setPathType(pathPerFloor.pathType);
                    instruction.setNextFloor(nextFloor);
                    instructions.add(instruction);
                } else if (points.length < 2) {
                    a = map.getWaypoints().getById(points[0].id);
                    Direction direction = new Direction(a, null, null, this.angleThreshold);
                    Instruction instruction2 = this.instructionFactory.createFromDirection(direction);
                    instruction2.setTurnReferenceAngle(0.0f);
                    instruction2.setPixelDistance(0.0f);
                    instructions.add(instruction2);
                } else {
                    a = map.getWaypoints().getById(points[points.length - 2].id);
                    Waypoint b = lastWaypoint;
                    Direction direction = new Direction(a, b, null, this.angleThreshold);
                    Instruction instruction3 = this.instructionFactory.createFromDirection(direction);
                    instruction3.setTurnReferenceAngle(Direction.getAngle(a, b));
                    instruction3.setPixelDistance(distanceCalculation);
                    instructions.add(instruction3);
                }
                ++i;
            }
        }
        return instructions.toArray(new Instruction[instructions.size()]);
    }

    public SurroundingElements getSurroundingElements(@NonNull SurroundingDefinition surroundingDefinition) {
        PointF startPt;
        float startAngle = surroundingDefinition.getGazeDirection() - (float)surroundingDefinition.getVisualLimitLeft();
        float gazeX = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float gazeY = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)surroundingDefinition.getGazeDirection() * Math.PI / 180.0));
        float endAngle = surroundingDefinition.getGazeDirection() + (float)surroundingDefinition.getVisualLimitRight();
        float gazeDegree = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), new PointF(gazeX, gazeY));
        SurroundingElements surroundingElements = new SurroundingElements();
        PointF center = surroundingDefinition.getPoint();
        float radius = surroundingDefinition.getVisualRange();
        HashMap<String, ArrayList<ArrayList>> segmentsOfInterest = new HashMap<String, ArrayList<ArrayList>>();
        HashMap<ArrayList, JShapeDrawable> segmentToShapeDictionary = new HashMap<ArrayList, JShapeDrawable>();
        ArrayList<String> allShapesArray = new ArrayList<String>();
        allShapesArray.addAll(surroundingDefinition.getLayersOfInterest());
        allShapesArray.addAll(surroundingDefinition.getVisualObstacles());
        ArrayList<PointF> viewPolygon = new ArrayList<PointF>();
        for (String layer : allShapesArray) {
            JShapeDrawable[] shapes = this.controller.getShapesInLayer(layer, surroundingDefinition.getMap());
            float startX = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)startAngle * Math.PI / 180.0));
            float startY = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)startAngle * Math.PI / 180.0));
            float endX = (float)((double)surroundingDefinition.getPoint().x + (double)surroundingDefinition.getVisualRange() * Math.cos((double)endAngle * Math.PI / 180.0));
            float endY = (float)((double)surroundingDefinition.getPoint().y + (double)surroundingDefinition.getVisualRange() * Math.sin((double)endAngle * Math.PI / 180.0));
            Path path = new Path();
            PointF p = new PointF(surroundingDefinition.getPoint().x, surroundingDefinition.getPoint().y);
            path.moveTo(p.x, p.y);
            p = new PointF(startX, startY);
            path.lineTo(p.x, p.y);
            p = new PointF(gazeX, gazeY);
            path.lineTo(p.x, p.y);
            p = new PointF(endX, endY);
            path.lineTo(p.x, p.y);
            path.close();
            if (viewPolygon.size() < 1) {
                viewPolygon.add(surroundingDefinition.getPoint());
                viewPolygon.add(new PointF(startX, startY));
                viewPolygon.add(new PointF(gazeX, gazeY));
                viewPolygon.add(new PointF(endX, endY));
            }
            RectF bounds = new RectF();
            path.computeBounds(bounds, true);
            for (JShapeDrawable shape : shapes) {
                if (!shape.getBounds().intersect(bounds)) continue;
                ArrayList segments = shape.getSegments();
                for (ArrayList segment : segments) {
                    PointF endPt;
                    startPt = (PointF)segment.get(0);
                    boolean doesIntersect = this.doesSegmentWithPoint(startPt, endPt = (PointF)segment.get(segment.size() - 1), center, radius);
                    if (!doesIntersect) continue;
                    if (shape.getClassName().equalsIgnoreCase(layer) && surroundingDefinition.getLayersOfInterest().contains(shape.getClassName())) {
                        ArrayList<ArrayList> interestLayer = (ArrayList<ArrayList>)segmentsOfInterest.get(layer);
                        if (interestLayer != null) {
                            interestLayer.add(segment);
                        } else {
                            interestLayer = new ArrayList<ArrayList>();
                        }
                        segmentsOfInterest.put(layer, interestLayer);
                        segmentToShapeDictionary.put(segment, shape);
                        continue;
                    }
                    ArrayList<ArrayList> obstacles = (ArrayList<ArrayList>)segmentsOfInterest.get("Obstacles");
                    if (obstacles != null) {
                        obstacles.add(segment);
                    } else {
                        obstacles = new ArrayList<ArrayList>();
                    }
                    segmentsOfInterest.put("Obstacles", obstacles);
                }
            }
        }
        ArrayList<ArrayList> finalSegmentArray = new ArrayList<ArrayList>();
        ArrayList closestGazeSegment = null;
        float closestDistance = Float.MAX_VALUE;
        ArrayList<PointF> gazeRay = new ArrayList<PointF>();
        gazeRay.add(surroundingDefinition.getPoint());
        gazeRay.add(new PointF(gazeX, gazeY));
        for (String segmentKey : segmentsOfInterest.keySet()) {
            for (ArrayList theSegment : (ArrayList)segmentsOfInterest.get(segmentKey)) {
                float distance;
                PointF intersection = this.getIntersectionWithRay(gazeRay, theSegment);
                if (intersection == null || !((distance = this.distanceBetweenPoint(intersection, surroundingDefinition.getPoint())) < closestDistance)) continue;
                closestDistance = distance;
                closestGazeSegment = theSegment;
            }
        }
        Path trackPath = new Path();
        trackPath.moveTo(surroundingDefinition.getPoint().x, surroundingDefinition.getPoint().y);
        trackPath.lineTo(gazeX, gazeY);
        ArrayList<SurroundingShape> surroundingShapesArray = new ArrayList<SurroundingShape>();
        for (String segmentKey : segmentsOfInterest.keySet()) {
            block6: for (ArrayList theSegment : (ArrayList)segmentsOfInterest.get(segmentKey)) {
                JShapeDrawable shape = (JShapeDrawable)segmentToShapeDictionary.get(theSegment);
                Boolean containsShape = false;
                for (SurroundingShape surrShape : surroundingShapesArray) {
                    if (surrShape.getShape() != shape) continue;
                    containsShape = true;
                    break;
                }
                if (containsShape.booleanValue()) continue;
                if (closestGazeSegment != null && closestGazeSegment.equals(theSegment)) {
                    finalSegmentArray.add(theSegment);
                    if (shape == null) continue;
                    SurroundingShape surroundingShape = new SurroundingShape();
                    surroundingShape.setShape(shape);
                    surroundingShape.setLayerName(shape.getClassName());
                    PointF intersectingPoint = new PointF();
                    float distance = this.distanceToSegment(surroundingDefinition.getPoint(), theSegment, intersectingPoint);
                    surroundingShape.setDistance(distance);
                    float shapeDegree = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), intersectingPoint);
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(gazeDegree, shapeDegree));
                    surroundingShapesArray.add(surroundingShape);
                    continue;
                }
                boolean pointInView = false;
                float rayAngle1 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)theSegment.get(0));
                float rayAngle2 = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), (PointF)theSegment.get(theSegment.size() - 1));
                float relativeAngle1 = this.getRelativeAngleWithDegrees(gazeDegree, rayAngle1);
                float relativeAngle2 = this.getRelativeAngleWithDegrees(gazeDegree, rayAngle2);
                if (relativeAngle1 < 0.0f && Math.abs(relativeAngle1) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    pointInView = true;
                }
                if (relativeAngle1 > 0.0f && Math.abs(relativeAngle1) < (float)surroundingDefinition.getVisualLimitRight()) {
                    pointInView = true;
                }
                if (relativeAngle2 < 0.0f && Math.abs(relativeAngle2) < (float)surroundingDefinition.getVisualLimitLeft()) {
                    pointInView = true;
                }
                if (relativeAngle2 > 0.0f && Math.abs(relativeAngle2) < (float)surroundingDefinition.getVisualLimitRight()) {
                    pointInView = true;
                }
                if (!pointInView) continue;
                startPt = theSegment.iterator();
                block8: while (startPt.hasNext()) {
                    PointF segmentPoint;
                    PointF castPoint = segmentPoint = (PointF)startPt.next();
                    ArrayList<PointF> ray = new ArrayList<PointF>();
                    ray.add(surroundingDefinition.getPoint());
                    ray.add(segmentPoint);
                    boolean lineOfSight = true;
                    for (String layerName : segmentsOfInterest.keySet()) {
                        for (ArrayList segment : (ArrayList)segmentsOfInterest.get(layerName)) {
                            PointF point2;
                            PointF point1;
                            PointF intersection;
                            if (segment == theSegment || (intersection = this.getIntersectionWithRay(ray, segment)) == null || (point1 = new PointF((float)Math.ceil(intersection.x), (float)Math.ceil(intersection.y))).equals((Object)(point2 = new PointF((float)Math.ceil(castPoint.x), (float)Math.ceil(castPoint.y))))) continue;
                            lineOfSight = false;
                            break;
                        }
                        if (lineOfSight) continue;
                        break;
                    }
                    if (!lineOfSight) continue;
                    finalSegmentArray.add(theSegment);
                    if (shape == null) continue block6;
                    for (SurroundingShape surrShape : surroundingShapesArray) {
                        if (surrShape.getShape() != shape) continue;
                        continue block8;
                    }
                    SurroundingShape surroundingShape = new SurroundingShape();
                    surroundingShape.setShape(shape);
                    surroundingShape.setLayerName(shape.getClassName());
                    PointF intersectingPoint = new PointF();
                    float distance = this.distanceToSegment(surroundingDefinition.getPoint(), theSegment, intersectingPoint);
                    surroundingShape.setDistance(distance);
                    float shapeDegree = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), intersectingPoint);
                    surroundingShape.setAngle(this.getRelativeAngleWithDegrees(gazeDegree, shapeDegree));
                    surroundingShapesArray.add(surroundingShape);
                    continue block6;
                }
            }
        }
        Collections.sort(surroundingShapesArray, new Comparator<SurroundingShape>(){

            @Override
            public int compare(SurroundingShape o1, SurroundingShape o2) {
                Float distance1 = Float.valueOf(o1.getDistance());
                Float distance2 = Float.valueOf(o2.getDistance());
                return distance1.compareTo(distance2);
            }
        });
        surroundingElements.setShapes(surroundingShapesArray.toArray(new SurroundingShape[surroundingShapesArray.size()]));
        Path path = new Path();
        if (viewPolygon.size() > 0) {
            PointF p0 = (PointF)viewPolygon.get(0);
            path.moveTo(p0.x, p0.y);
            for (int i = 1; i < viewPolygon.size(); ++i) {
                PointF p = (PointF)viewPolygon.get(i);
                path.lineTo(p.x, p.y);
            }
            path.close();
        }
        ArrayList<SurroundingIcon> containedIconsArray = new ArrayList<SurroundingIcon>();
        ArrayList iconsOfInterest = new ArrayList();
        for (String layerName : surroundingDefinition.getLayersOfInterest()) {
            ArrayList<JIconDrawable> iconsArray = new ArrayList<JIconDrawable>();
            MapLayer mapLayer = this.controller.getMapView().getCurrentMapDrawable().getMapLayer(layerName);
            if (mapLayer != null) {
                iconsArray.addAll(new ArrayList<JIconDrawable>(Arrays.asList(mapLayer.getIconDrawables())));
            }
            iconsOfInterest.addAll(iconsArray);
        }
        for (JIconDrawable icon : iconsOfInterest) {
            Waypoint waypoint = surroundingDefinition.getMap().getWaypoints().getById(icon.getWaypointId());
            if (waypoint == null) continue;
            PointF wpPoint = new PointF(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue());
            RectF rectF = new RectF();
            path.computeBounds(rectF, true);
            Region r = new Region();
            r.setPath(path, new Region((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom));
            if (!r.contains((int)wpPoint.x, (int)wpPoint.y)) continue;
            boolean hasSight = true;
            ArrayList<PointF> iconRay = new ArrayList<PointF>();
            iconRay.add(surroundingDefinition.getPoint());
            iconRay.add(wpPoint);
            for (ArrayList segment : finalSegmentArray) {
                PointF intersection = this.getIntersectionWithRay(iconRay, segment);
                if (intersection == null) continue;
                hasSight = false;
                break;
            }
            if (!hasSight) continue;
            SurroundingIcon surroundingIcon = new SurroundingIcon();
            surroundingIcon.setIcon(icon);
            surroundingIcon.setLayerName(icon.getClassName());
            float iconDegree = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), wpPoint);
            gazeDegree = this.pointPairToBearingDegrees(surroundingDefinition.getPoint(), new PointF(gazeX, gazeY));
            surroundingIcon.setAngle(this.getRelativeAngleWithDegrees(gazeDegree, iconDegree));
            surroundingIcon.setDistance(this.distanceBetweenPoint(surroundingDefinition.getPoint(), wpPoint));
            containedIconsArray.add(surroundingIcon);
        }
        Collections.sort(containedIconsArray, new Comparator<SurroundingIcon>(){

            @Override
            public int compare(SurroundingIcon o1, SurroundingIcon o2) {
                Float distance1 = Float.valueOf(o1.getDistance());
                Float distance2 = Float.valueOf(o2.getDistance());
                return distance1.compareTo(distance2);
            }
        });
        surroundingElements.setIcons(containedIconsArray.toArray(new SurroundingIcon[containedIconsArray.size()]));
        return surroundingElements;
    }

    public void setInstructionFactory(@NonNull InstructionFactory instructionFactory) {
        this.instructionFactory = instructionFactory;
    }

    public boolean hasUserVeeredOffRoute(@NonNull PathPerFloor[] pathPerFloors, float threshold) {
        UserLocation userLocation = UserLocation.getInstance();
        for (PathPerFloor pathPerFloor : pathPerFloors) {
            if (userLocation.getMapId() != pathPerFloor.mapId || pathPerFloor.points.length < 2) continue;
            PointF userLocationPosition = new PointF(userLocation.getX(), userLocation.getY());
            ArrayList<Float> distanceList = new ArrayList<Float>();
            for (int i = 0; i < pathPerFloor.points.length - 1; ++i) {
                float distance = Utilities.distanceFromPointToLine((PointF)userLocationPosition, (PointF)pathPerFloor.points[i].asPointF(), (PointF)pathPerFloor.points[i + 1].asPointF());
                distanceList.add(Float.valueOf(distance));
            }
            return ((Float)Collections.min(distanceList)).floatValue() * this.controller.getCurrentMap().getMmPerPixel() > threshold;
        }
        return false;
    }

    private boolean doesSegmentWithPoint(PointF p1, PointF p2, PointF center, float radius) {
        float c;
        boolean ptCheck1 = this.circleWithCenter(center, radius, p1);
        boolean ptCheck2 = this.circleWithCenter(center, radius, p2);
        if (ptCheck1 || ptCheck2) {
            return true;
        }
        PointF direction = new PointF(p2.x - p1.x, p2.y - p1.y);
        PointF vector = new PointF(p1.x - center.x, p1.y - center.y);
        float a = this.dotProductOfPoint(direction, direction);
        float b = 2.0f * this.dotProductOfPoint(vector, direction);
        float discriminant = b * b - 4.0f * a * (c = this.dotProductOfPoint(vector, vector) - radius * radius);
        if (discriminant < 0.0f) {
            return false;
        }
        discriminant = (float)Math.sqrt(discriminant);
        float t1 = (-b - discriminant) / (2.0f * a);
        float t2 = (-b + discriminant) / (2.0f * a);
        if (t1 >= 0.0f && t1 <= 1.0f) {
            return true;
        }
        return t2 >= 0.0f && t2 <= 1.0f;
    }

    private boolean circleWithCenter(PointF center, float radius, PointF point) {
        float ptCheck = (float)Math.sqrt((point.x - center.x) * (point.x - center.x) + (point.y - center.y) * (point.y - center.y));
        return ptCheck <= radius;
    }

    private float dotProductOfPoint(PointF v1, PointF v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    private PointF getIntersectionWithRay(ArrayList<PointF> ray, ArrayList<PointF> segment) {
        PointF rayA = ray.get(0);
        PointF rayB = ray.get(ray.size() - 1);
        float aRayPointX = rayA.x;
        float aRayPointY = rayA.y;
        float bRayPointX = rayB.x;
        float bRayPointY = rayB.y;
        PointF p1 = new PointF(aRayPointX, aRayPointY);
        PointF p2 = new PointF(bRayPointX, bRayPointY);
        PointF segmentA = segment.get(0);
        PointF segmentB = segment.get(segment.size() - 1);
        float aSegmentPointX = segmentA.x;
        float aSegmentPointY = segmentA.y;
        float bSegmentPointX = segmentB.x;
        float bSegmentPointY = segmentB.y;
        PointF p3 = new PointF(aSegmentPointX, aSegmentPointY);
        PointF p4 = new PointF(bSegmentPointX, bSegmentPointY);
        float d = (p2.x - p1.x) * (p4.y - p3.y) - (p2.y - p1.y) * (p4.x - p3.x);
        if (d == 0.0f) {
            return null;
        }
        float u = ((p3.x - p1.x) * (p4.y - p3.y) - (p3.y - p1.y) * (p4.x - p3.x)) / d;
        float v = ((p3.x - p1.x) * (p2.y - p1.y) - (p3.y - p1.y) * (p2.x - p1.x)) / d;
        if ((double)u < 0.0 || (double)u > 1.0) {
            return null;
        }
        if ((double)v < 0.0 || (double)v > 1.0) {
            return null;
        }
        PointF intersection = new PointF(p1.x + u * (p2.x - p1.x), p1.y + u * (p2.y - p1.y));
        return intersection;
    }

    private float distanceBetweenPoint(PointF point1, PointF point2) {
        float xDistance = point2.x - point1.x;
        float yDistance = point2.y - point1.y;
        float distance = (float)Math.sqrt(xDistance * xDistance + yDistance * yDistance);
        return distance;
    }

    private float pointPairToBearingDegrees(PointF startingPoint, PointF endingPoint) {
        PointF vector = new PointF(endingPoint.x - startingPoint.x, endingPoint.y - startingPoint.y);
        double angleCalc = vector.y < 0.0f ? Math.atan2(-vector.y, vector.x) : Math.atan2(vector.y, -vector.x) + Math.PI;
        return (float)(angleCalc * 57.29577951308232);
    }

    private float getRelativeAngleWithDegrees(float gazeAngle, float itemAngle) {
        if (Math.abs(itemAngle - gazeAngle) > 180.0f) {
            if (itemAngle > gazeAngle) {
                return (float)Math.abs(360.0 - (double)itemAngle + (double)gazeAngle);
            }
            if (itemAngle < gazeAngle) {
                return -Math.abs(360.0f - gazeAngle + itemAngle);
            }
        } else {
            if (itemAngle > gazeAngle) {
                return -(itemAngle - gazeAngle);
            }
            if (itemAngle < gazeAngle) {
                return gazeAngle - itemAngle;
            }
        }
        return 0.0f;
    }

    private float getPixelsFromInches(float inches) {
        return this.getPixelsFromMillimeters((float)((double)inches * 25.4));
    }

    private float getPixelsFromMillimeters(float millimeters) {
        return millimeters / this.controller.getCurrentMap().getMmPerPixel();
    }

    private float distanceToSegment(PointF point, ArrayList<PointF> line, PointF intersectPoint) {
        PointF lineP2;
        PointF lineP1 = line.get(0);
        float l2 = this.distanceBetweenPoint(lineP1, lineP2 = line.get(line.size() - 1));
        if (l2 == 0.0f) {
            intersectPoint.set(lineP2.x, lineP2.y);
            return this.distanceBetweenPoint(point, lineP2);
        }
        float t = ((point.x - lineP1.x) * (lineP2.x - lineP1.x) + (point.y - lineP1.y) * (lineP2.y - lineP1.y)) / l2;
        if (t < 0.0f) {
            intersectPoint.set(lineP1.x, lineP1.y);
            return this.distanceBetweenPoint(point, lineP1);
        }
        if (t > 1.0f) {
            intersectPoint.set(lineP2.x, lineP2.y);
            return this.distanceBetweenPoint(point, lineP2);
        }
        intersectPoint = new PointF(lineP1.x + t * (lineP2.x - lineP1.x), lineP1.y + t * (lineP2.y - lineP1.y));
        return (float)Math.sqrt(this.distanceBetweenPoint(point, intersectPoint));
    }
}

