package com.jibestream.navigationkit.instructionfactory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import com.jibestream.navigationkit.surroundings.SurroundingElements;

/**
 * Created by Andrew Adams on 2017-05-15.
 */

public class Instruction {

    private String direction;
    private String text;
    private String defaultInstruction;

    private float turnReferenceAngle;
    private float pixelDistance;

    private PathType pathType;
    private Waypoint originPoint;
    private Waypoint decisionPoint;
    private Waypoint completionPoint;
    private Floor nextFloor;

    private SurroundingDefinition surroundingDefinition;
    private SurroundingElements surroundingElements;

    public Instruction() {

    }

    public Instruction(@NonNull Direction direction) {
        setDistanceWithDirection(direction);
        setPointsWithDirection(direction);
        setTextWithDirection(direction);
    }

    public void setDistanceWithDirection(@NonNull Direction direction) {
        if (direction == null ||
                direction.getA() == null || direction.getB() == null) {
            return;
        }
        Float[] aCoords = direction.getA().getCoordinates();
        Float[] bCoords = direction.getB().getCoordinates();

        if (aCoords.length > 0 && bCoords.length > 0) {
            pixelDistance = Math.round(Math.sqrt(Math.pow(bCoords[0] - aCoords[0], 2) + Math.pow(bCoords[1] - aCoords[1], 2)));
        }
    }

    public void setPointsWithDirection(@NonNull Direction direction) {
        originPoint = direction.getA();
        decisionPoint = direction.getC() != null ? direction.getB() : null;
        completionPoint = direction.getC() != null ? direction.getC() : direction.getB();
    }

    public void setTextWithDirection(@NonNull Direction direction) {
        this.direction = direction.getValue();

        if (direction.getC() != null) {
            text = "Turn " + direction.getValue();
        } else {
            text = "Arrive at your destination";
        }
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(@NonNull String direction) {
        this.direction = direction;
    }

    public String getText() {
        return text;
    }

    public void setText(@NonNull String text) {
        this.text = text;
    }

    public String getDefaultInstruction() {
        return defaultInstruction;
    }

    public void setDefaultInstruction(@NonNull String defaultInstruction) {
        this.defaultInstruction = defaultInstruction;
    }

    public float getTurnReferenceAngle() {
        return turnReferenceAngle;
    }

    public void setTurnReferenceAngle(float turnReferenceAngle) {
        this.turnReferenceAngle = turnReferenceAngle;
    }

    public float getPixelDistance() {
        return pixelDistance;
    }

    public void setPixelDistance(float pixelDistance) {
        this.pixelDistance = pixelDistance;
    }

    public PathType getPathType() {
        return pathType;
    }

    public void setPathType(@Nullable PathType pathType) {
        this.pathType = pathType;
    }

    public Waypoint getOriginPoint() {
        return originPoint;
    }

    public void setOriginPoint(@NonNull Waypoint originPoint) {
        this.originPoint = originPoint;
    }

    public Waypoint getDecisionPoint() {
        return decisionPoint;
    }

    public void setDecisionPoint(@Nullable Waypoint decisionPoint) {
        this.decisionPoint = decisionPoint;
    }

    public Waypoint getCompletionPoint() {
        return completionPoint;
    }

    public void setCompletionPoint(@NonNull Waypoint completionPoint) {
        this.completionPoint = completionPoint;
    }

    public Floor getNextFloor() { return nextFloor; }

    public void setNextFloor(@Nullable Floor nextFloor) {
        this.nextFloor = nextFloor;
    }

    public SurroundingDefinition getSurroundingDefinition() {
        return surroundingDefinition;
    }

    public void setSurroundingDefinition(@NonNull SurroundingDefinition surroundingDefinition) {
        this.surroundingDefinition = surroundingDefinition;
    }

    public SurroundingElements getSurroundingElements() {
        return surroundingElements;
    }

    public void setSurroundingElements(@NonNull SurroundingElements surroundingElements) {
        this.surroundingElements = surroundingElements;
    }

    @Override
    public String toString() {
        String instructionString = "";
        instructionString += direction != null ? "direction = " + direction + "\n" : "";
        instructionString += text != null ? "text = " + text + "\n" : "";
        instructionString += defaultInstruction != null ? "defaultInstruction = " + defaultInstruction + "\n" : "";
        instructionString += "turnReferenceAngle = " + turnReferenceAngle + "\n";
        instructionString += "pixelDistance = " + pixelDistance + "\n";
        instructionString += pathType != null ? "pathType = " + pathType.toString() + "\n" : "";
        instructionString += originPoint != null ? "originPoint = " + originPoint + "\n" : "originPoint = null" + "\n";
        instructionString += decisionPoint != null ? "decisionPoint = " + decisionPoint + "\n" : "decisionPoint = null" + "\n";
        instructionString += completionPoint != null ? "completionPoint = " + completionPoint + "\n" : "completionPoint = null" + "\n";
        instructionString += nextFloor != null ? "nextFloor = " + nextFloor + "\n" : "";
        instructionString += surroundingDefinition != null ? "surroundingDefinition = " + surroundingDefinition + "\n" : "surroundingDefinition = null" + "\n";
        instructionString += surroundingElements != null ? "surroundingElements = " + surroundingElements.getShapes().length + "\n" : "surroundingElements = null";

        return instructionString;
    }
}
