/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import com.jibestream.jmapandroidsdk.collections.MapCollection;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.Waypoint;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.navigationkit.NavigationKit;
import com.jibestream.navigationkit.instructionfactory.Direction;
import com.jibestream.navigationkit.instructionfactory.Instruction;
import com.jibestream.navigationkit.surroundings.SurroundingDefinition;
import java.util.ArrayList;

public class InstructionFactory {
    private NavigationKit navKit;
    private JController controller;
    private int visualLimitLeft;
    private int visualLimitRight;
    private int visualRange;
    private ArrayList<String> layersOfInterest;
    private ArrayList<String> visualObstacles;

    public InstructionFactory(NavigationKit navKit, JController controller) {
        this.navKit = navKit;
        this.controller = controller;
        this.visualLimitLeft = 60;
        this.visualLimitRight = 60;
        this.visualRange = 250;
        this.layersOfInterest = new ArrayList();
        this.visualObstacles = new ArrayList();
    }

    public Instruction createFromDirection(Direction direction) {
        Instruction instruction = new Instruction(direction);
        this.setSurroundingDefinitionWithInstruction(instruction);
        this.setSurroundingElementsWithInstruction(instruction);
        return instruction;
    }

    public Instruction createEmpty() {
        return new Instruction();
    }

    public void setSurroundingElementsWithInstruction(Instruction instruction) {
        instruction.setSurroundingElements(this.navKit.getSurroundingElements(instruction.getSurroundingDefinition()));
    }

    public void setSurroundingDefinitionWithInstruction(Instruction instruction) {
        Map map;
        MapCollection mapCollection = this.controller.getActiveVenue().getMaps();
        Waypoint waypoint = instruction.getOriginPoint();
        Waypoint nextWaypoint = instruction.getDecisionPoint();
        if (nextWaypoint == null && instruction.getCompletionPoint() != null) {
            nextWaypoint = instruction.getCompletionPoint();
        }
        if ((map = mapCollection.getById(waypoint.getMapId())) == null) {
            return;
        }
        PointF newPoint = new PointF(waypoint.getCoordinates()[0].floatValue(), waypoint.getCoordinates()[1].floatValue());
        SurroundingDefinition surroundingDefinition = new SurroundingDefinition(map, newPoint);
        surroundingDefinition.setGazeDirection(Direction.getAngle(waypoint, nextWaypoint));
        surroundingDefinition.setVisualLimitLeft(this.visualLimitLeft);
        surroundingDefinition.setVisualLimitRight(this.visualLimitRight);
        surroundingDefinition.setVisualRange(this.visualRange);
        surroundingDefinition.addAllLayersOfInterest(this.layersOfInterest);
        surroundingDefinition.addAllLayersOfInterest(this.visualObstacles);
        instruction.setSurroundingDefinition(surroundingDefinition);
    }

    public SurroundingDefinition getSurroundingDefinitionForInstruction(Instruction instruction) {
        return instruction.getSurroundingDefinition();
    }

    public int getVisualLimitLeft() {
        return this.visualLimitLeft;
    }

    public void setVisualLimitLeft(int visualLimitLeft) {
        this.visualLimitLeft = visualLimitLeft;
    }

    public int getVisualLimitRight() {
        return this.visualLimitRight;
    }

    public void setVisualLimitRight(int visualLimitRight) {
        this.visualLimitRight = visualLimitRight;
    }

    public int getVisualRange() {
        return this.visualRange;
    }

    public void setVisualRange(int visualRange) {
        this.visualRange = visualRange;
    }

    public void addLayerOfInterest(String layerName) {
        this.layersOfInterest.add(layerName);
    }

    public void removeLayerOfInterest(String layerName) {
        this.layersOfInterest.remove(layerName);
    }

    public void addVisualObstacles(String visualObstacleName) {
        this.visualObstacles.add(visualObstacleName);
    }

    public void removeVisualObstacles(String visualObstacleName) {
        this.visualObstacles.remove(visualObstacleName);
    }
}

