package com.jibestream.navigationkit;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;

import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;

/**
 * Created by Ken Pangilinan on 2017-05-19.
 */

public class RayDrawable extends JDrawable {
    private Paint paint;
    private Path path;
    private PointF point;

    public RayDrawable(Path path) {
        this.path = path;

        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(Color.RED);
        this.paint.setAlpha(200);
        this.paint.setStrokeWidth(1);

        setVisible(true);
    }

    @Override
    public void draw(Canvas canvas) {
        if (path != null) {
            canvas.drawPath(path, paint);
        }
    }

    public PointF getPoint() {
        return point;
    }

    public void setPoint(PointF point) {
        this.point = point;
    }
}
