package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;

import com.jibestream.jmapandroidsdk.components.Waypoint;

/**
 * Created by Andrew Adams on 2017-05-15.
 */
public class Direction {

    private int threshold;
    public final static String RIGHT = "Right";
    public final static String LEFT = "Left";
    public final static String FORWARD = "Forward";
    public final static String UTURN = "UTurn";
    public final static String ARRIVE = "Arrive";

    private String value;
    private Waypoint a,b,c;

    private float angle;

    public Direction (Waypoint a, Waypoint b, Waypoint c) {
        //default threshold to 20
        this(a, b, c, 20);
    }

    public Direction (Waypoint a, Waypoint b, Waypoint c, int threshold) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.threshold = threshold;

        if (this.c != null) {
            angle = getAngle(b, c) - getAngle(a, b);
            value = getValue();
        } else {
            value = ARRIVE;
        }
    }

    public String getValue() {
        if ((angle > threshold && angle < 180 - threshold) || (angle < -180 - threshold)) {
            return RIGHT;
        } else if ((angle < 0 - threshold && angle > -180 + threshold) || (angle > 180 + threshold)) {
            return LEFT;
        } else if (angle >= 0 - threshold && angle <= threshold) {
            return FORWARD;
        } else {
            return UTURN;
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static float getAngle (Waypoint startingWaypoint, Waypoint targetWaypoint) {

        Float[] startingCoords = startingWaypoint.getCoordinates();
        Float[] targetCoords = targetWaypoint.getCoordinates();

        double theta = Math.atan2(targetCoords[1] - startingCoords[1], targetCoords[0] - startingCoords[0]);

        double angle = Math.toDegrees(theta);

        if (angle < 0) {
            angle += 360;
        }

        return (float) angle;
    }

    public static float getAngle (PointF startingPoint, PointF targetPoint) {
        double theta = Math.atan2(targetPoint.y - startingPoint.y, targetPoint.x - startingPoint.x);

        double angle = Math.toDegrees(theta);

        if (angle < 0) {
            angle += 360;
        }

        return (float) angle;
    }

    public Waypoint getA() {
        return a;
    }

    public void setA(Waypoint a) {
        this.a = a;
    }

    public Waypoint getB() {
        return b;
    }

    public void setB(Waypoint b) {
        this.b = b;
    }

    public Waypoint getC() {
        return c;
    }

    public void setC(Waypoint c) {
        this.c = c;
    }

    public int getThreshold() {
        return threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public float getAngle() {
        return angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}
