/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.navigationkit.instructionfactory;

import android.graphics.PointF;
import com.jibestream.jmapandroidsdk.components.Waypoint;

public class Direction {
    public static int THRESHOLD = 20;
    public static final String RIGHT = "Right";
    public static final String LEFT = "Left";
    public static final String FORWARD = "Forward";
    public static final String UTURN = "UTurn";
    public static final String ARRIVE = "Arrive";
    private String value;
    private Waypoint a;
    private Waypoint b;
    private Waypoint c;
    private float angle;

    public Direction(Waypoint a, Waypoint b, Waypoint c) {
        this.a = a;
        this.b = b;
        this.c = c;
        if (this.c != null) {
            this.angle = Direction.getAngle(b, c) - Direction.getAngle(a, b);
            this.value = this.getValue();
        } else {
            this.value = ARRIVE;
        }
    }

    public String getValue() {
        if (this.angle > (float)THRESHOLD && this.angle < (float)(180 - THRESHOLD) || this.angle < (float)(-180 - THRESHOLD)) {
            return RIGHT;
        }
        if (this.angle < (float)(0 - THRESHOLD) && this.angle > (float)(-180 + THRESHOLD) || this.angle > (float)(180 + THRESHOLD)) {
            return LEFT;
        }
        if (this.angle >= (float)(0 - THRESHOLD) && this.angle <= (float)THRESHOLD) {
            return FORWARD;
        }
        return UTURN;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static float getAngle(Waypoint startingWaypoint, Waypoint targetWaypoint) {
        Float[] startingCoords = startingWaypoint.getCoordinates();
        Float[] targetCoords = targetWaypoint.getCoordinates();
        double theta = Math.atan2(targetCoords[1].floatValue() - startingCoords[1].floatValue(), targetCoords[0].floatValue() - startingCoords[0].floatValue());
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    public static float getAngle(PointF startingPoint, PointF targetPoint) {
        double theta = Math.atan2(targetPoint.y - startingPoint.y, targetPoint.x - startingPoint.x);
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    public Waypoint getA() {
        return this.a;
    }

    public void setA(Waypoint a) {
        this.a = a;
    }

    public Waypoint getB() {
        return this.b;
    }

    public void setB(Waypoint b) {
        this.b = b;
    }

    public Waypoint getC() {
        return this.c;
    }

    public void setC(Waypoint c) {
        this.c = c;
    }

    public int getThreshold() {
        return THRESHOLD;
    }

    public void setThreshold(int THRESHOLD) {
        Direction.THRESHOLD = THRESHOLD;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

