/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.mapuikit;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import com.jibestream.mapuikit.PopupDrawableOptions;

public class PopupDrawable
extends JDrawable {
    private final boolean showActionButton;
    private String titleText;
    private JStyle titleTextStyle;
    private Rect titleTextBounds;
    private String subText;
    private JStyle subTextStyle;
    private Rect subTitleTextBounds;
    private String actionButtonText;
    private JStyle actionButtonTextStyle;
    private Rect actionButtonTextBounds;
    private JStyle actionButtonStyle;
    private String closeButtonText;
    private Rect closeButtonBounds;
    private JStyle closeButtonStyle;
    private RectF closeButtonBox;
    private JStyle popupStyle;
    private float pointerSize;
    private RectF popupBox;
    private Path popupPointer;
    private float padding;
    private int spacing;
    private RectF actionBox;
    private PopupDrawableOptions options;
    private float rotation;
    private float opacity;

    public PopupDrawable(PopupDrawableOptions popupOptions) {
        JStyle closeBtnStyle;
        this.titleText = popupOptions.titleText;
        this.subText = popupOptions.subText;
        this.actionButtonText = popupOptions.actionButtonText;
        this.actionButtonStyle = popupOptions.actionButtonStyle;
        this.actionButtonTextStyle = popupOptions.actionButtonTextStyle;
        this.showActionButton = popupOptions.showActionButton;
        this.titleTextStyle = popupOptions.titleTextStyle;
        this.subTextStyle = popupOptions.subTextStyle;
        this.popupStyle = popupOptions.popupStyle;
        this.titleTextBounds = new Rect();
        this.titleTextStyle.getTextBounds(this.titleText, 0, this.titleText.length(), this.titleTextBounds);
        if (this.subText != null && !this.subText.isEmpty()) {
            this.subTitleTextBounds = new Rect();
            this.subTextStyle.getTextBounds(this.subText, 0, this.subText.length(), this.subTitleTextBounds);
        }
        if (this.actionButtonText != null && !this.actionButtonText.isEmpty()) {
            this.actionButtonTextBounds = new Rect();
            this.actionButtonTextStyle.getTextBounds(this.actionButtonText, 0, this.actionButtonText.length(), this.actionButtonTextBounds);
        }
        this.closeButtonStyle = closeBtnStyle = new JStyle(popupOptions.titleTextStyle.getColor());
        this.closeButtonText = "X";
        this.closeButtonBounds = new Rect();
        this.closeButtonStyle.getTextBounds(this.closeButtonText, 0, this.closeButtonText.length(), this.closeButtonBounds);
        this.setHeadsUp(true);
        this.pointerSize = 10.0f;
        this.padding = 15.0f;
        this.spacing = 5;
        this.setVisible(true);
    }

    public void draw(Canvas canvas) {
        int maxWidth = Math.max(this.titleTextBounds.width(), this.subTitleTextBounds != null ? this.subTitleTextBounds.width() : 0);
        this.popupBox = new RectF(this.getX() - (float)(maxWidth / 2) - this.padding, this.getY() - this.pointerSize - (float)this.titleTextBounds.height() - this.padding * 2.0f - (float)(this.subTitleTextBounds != null ? this.subTitleTextBounds.height() + this.spacing : 0) - (this.actionButtonTextBounds != null && !this.actionButtonText.isEmpty() && this.showActionButton ? (float)this.actionButtonTextBounds.height() + this.padding * 3.0f : 0.0f), this.getX() + (float)(maxWidth / 2) + this.padding, this.getY() - this.pointerSize);
        this.popupPointer = new Path();
        this.popupPointer.moveTo(this.getX(), this.getY());
        this.popupPointer.rLineTo(-(this.pointerSize / 2.0f), -this.pointerSize);
        this.popupPointer.rLineTo(this.pointerSize, 0.0f);
        this.popupPointer.close();
        canvas.drawRoundRect(this.popupBox, 5.0f, 5.0f, (Paint)this.popupStyle);
        canvas.drawPath(this.popupPointer, (Paint)this.popupStyle);
        float top = this.popupBox.top + this.padding + (float)this.titleTextBounds.height();
        canvas.drawText(this.titleText, this.popupBox.left + this.padding, top, (Paint)this.titleTextStyle);
        if (this.subTitleTextBounds != null) {
            canvas.drawText(this.subText, this.popupBox.left + this.padding, top += (float)(this.subTitleTextBounds.height() + this.spacing), (Paint)this.subTextStyle);
        }
        if (this.actionButtonTextBounds != null && !this.actionButtonText.isEmpty() && this.showActionButton) {
            this.actionBox = new RectF((float)((int)(this.popupBox.left + this.padding)), top += this.padding, (float)((int)(this.popupBox.right - this.padding)), top + (float)this.actionButtonTextBounds.height() + this.padding * 2.0f);
            canvas.drawRoundRect(this.actionBox, 5.0f, 5.0f, (Paint)this.actionButtonStyle);
            canvas.drawText(this.actionButtonText, this.actionBox.centerX() - (float)(this.actionButtonTextBounds.width() / 2), this.actionBox.centerY() + (float)(this.actionButtonTextBounds.height() / 2), (Paint)this.actionButtonTextStyle);
        }
        float leftClose = this.popupBox.right - (float)this.closeButtonBounds.width() - 5.0f;
        float topClose = this.popupBox.top;
        float rightClose = this.popupBox.right;
        float bottomClose = this.popupBox.top + (float)this.closeButtonBounds.height() + 10.0f;
        this.closeButtonBox = new RectF(leftClose, topClose, rightClose, bottomClose);
        canvas.drawText(this.closeButtonText, this.popupBox.right - (float)this.closeButtonBounds.width() - 5.0f, this.popupBox.top + (float)this.closeButtonBounds.height() + 5.0f, (Paint)this.closeButtonStyle);
    }

    public RectF getBounds() {
        if (this.isHeadsUp()) {
            RectF rotatedPopupBox = this.popupBox;
            Matrix m = new Matrix();
            m.setRotate(this.rotation, this.getX(), this.getY());
            m.mapRect(rotatedPopupBox);
            return rotatedPopupBox;
        }
        return this.popupBox;
    }

    public PopupDrawableOptions getOptions() {
        return this.options;
    }

    public void setOptions(@NonNull PopupDrawableOptions options) {
        this.options = options;
    }

    public void popupTapped(PointF point, @NonNull OnPopupTapCallback onPopupTapCallback) {
        if (onPopupTapCallback == null) {
            return;
        }
        if (this.isHeadsUp()) {
            RectF rotatedActionBox = this.actionBox;
            Matrix m = new Matrix();
            m.setRotate(this.rotation, this.getX(), this.getY());
            m.mapRect(rotatedActionBox);
            this.actionBox = rotatedActionBox;
            m.setRotate(this.rotation, this.getX(), this.getY());
            RectF rotatedCloseBox = this.closeButtonBox;
            m.mapRect(rotatedCloseBox);
            this.closeButtonBox = rotatedCloseBox;
        }
        if (this.actionBox.contains((float)((int)point.x), (float)((int)point.y))) {
            onPopupTapCallback.onActionButtonTapped();
            return;
        }
        if (this.closeButtonBox.contains((float)((int)point.x), (float)((int)point.y))) {
            onPopupTapCallback.onCloseButtonTapped();
            return;
        }
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public static interface OnPopupTapCallback {
        public void onActionButtonTapped();

        public void onCloseButtonTapped();
    }
}

