package com.jibestream.mapuikit;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.RelativeLayout;

import com.jibestream.jmapandroidsdk.components.Amenity;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.components.Destination;
import com.jibestream.jmapandroidsdk.components.PathType;

/**
 * Created by Ken Pangilinan on 2018-03-29.
 */

public class SearchOptions {
    int position;
    BaseModel[] searchArray;
    int maxResults;
    String hint;

    /**
     * {@link Search}' options.
     *
     * @param searchArray         Pass in {@code null} to populate w/ {@link Destination}s, {@link Amenity}s and {@link PathType}s.
     *                            Otherwise pass in one of the previously mentioned {@link BaseModel} objects.
     *
     *  {@code
     *   if (o instanceof Destination) {
     *          //TODO: handle destination object
     *      } else if (o instanceof Amenity) {
     *          //TODO: handle amenity object
     *      } else if (o instanceof PathType) {
     *          //TODO: handle path type object
     *      }}
     *  </pre>
     */
    public SearchOptions(@Nullable BaseModel[] searchArray) {
        position = RelativeLayout.ALIGN_PARENT_TOP;

        maxResults = 5;
        hint = "Search...";

    }

    /**
     * @param position This position is to assign where to snap the search on the y-axis.
     *                 RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.CENTER_VERTICAL, RelativeLayout.ALIGN_PARENT_TOP
     *                 Defaults to top-center. You cannot set the x-axis since this component uses the full map width already.
     */
    public void setPosition(int position) {
        this.position = position;
    }

    /**
     * @param searchArray Different {@link BaseModel}s supported are {@link Destination}, {@link Amenity} and {@link PathType}.
     */
    public void setSearchArray(@NonNull BaseModel[] searchArray) {
        this.searchArray = new BaseModel[searchArray.length];
        this.searchArray = searchArray;
    }

    /**
     * @param maxResults Max number of results to display in the list.
     */
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * @param hint Hint text of search.
     */
    public void setHint(@NonNull String hint) {
        this.hint = hint;
    }


}
