package com.jibestream.mapuikit;

import android.graphics.Color;
import android.widget.RelativeLayout;

import com.jibestream.jmapandroidsdk.styles.JStyle;

/**
 * Created by Ken Pangilinan on 2018-03-29.
 */

public class FloorSelectorOptions {
    JStyle activeStyle;
    JStyle activeFontStyle;

    JStyle inactiveStyle;
    JStyle inactiveFontStyle;

    int[] position;

    boolean vertical;

    //TODO: do we need this?
    int maxHeight;

    /**
     * {@link FloorSelector}' options.
     */
    public FloorSelectorOptions() {
    }

    /**
     * @param position Index 0 is to assign where to snap the search on the x-axis.
     *                 RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.ALIGN_PARENT_RIGHT
     *                 Index 1 is to assign where to snap the search on the y-axis.
     *                 RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.CENTER_VERTICAL, RelativeLayout.ALIGN_PARENT_TOP
     *                 Defaults to bottom-right.
     */
    public void setPosition(int[] position) {
        this.position = position;
    }

    /**
     * @param activeStyle Style of floor button that has been selected. Defaults to Color.WHITE
     */
    public void setActiveStyle(JStyle activeStyle) {
        this.activeStyle = activeStyle;
    }

    /**
     * @param activeFontStyle Style of floor button text that has been selected. Defaults to Color.RED
     */
    public void setActiveFontStyle(JStyle activeFontStyle) {
        this.activeFontStyle = activeFontStyle;
    }

    /**
     * @param inactiveStyle Style of all the floor buttons. Defaults to Color.WHITE
     */
    public void setInactiveStyle(JStyle inactiveStyle) {
        this.inactiveStyle = inactiveStyle;
    }

    /**
     * @param inactiveFontStyle Style of all the floor buttons text. Defaults to Color.BLACK
     */
    public void setInactiveFontStyle(JStyle inactiveFontStyle) {
        this.inactiveFontStyle = inactiveFontStyle;
    }

    /**
     * @param vertical {@code true} = vertical layout, {@code false} = horizontal layout.
     */
    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }
}