package com.jibestream.mapuikit;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

/**
 * Created by Ken Pangilinan on 2018-04-09.
 */

public class Compass extends android.support.v7.widget.AppCompatImageView {
    private CompassOptions options;
    boolean isCompassNorth;

    public Compass(Context context) {
        super(context);

        init();
    }

    public Compass(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        init();
    }

    public Compass(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init();
    }

    private void init() {
        isCompassNorth = true;
    }

    @Override
    public void setImageResource(int resId) {
        super.setImageResource(resId == 0 ? R.drawable.ic_compass : resId);
    }

    /**
     * @return Options for compass.
     */
    public CompassOptions getOptions() {
        return options;
    }

    /**
     * @param options Set options for compass.
     */
    public void setOptions(@NonNull CompassOptions options) {
        this.options = options;
    }

    @Override
    public void setRotation(float rotation) {
        super.setRotation(rotation);
    }
}
