/*
 * Decompiled with CFR 0.152.
 */
package com.jibestream.mapuikit;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.widget.CursorAdapter;
import android.support.v4.widget.SimpleCursorAdapter;
import android.support.v7.widget.SearchView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.daimajia.androidanimations.library.Techniques;
import com.daimajia.androidanimations.library.YoYo;
import com.jibestream.jmapandroidsdk.analytics_kit.AnalyticsEvent;
import com.jibestream.jmapandroidsdk.components.Amenity;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.components.Destination;
import com.jibestream.jmapandroidsdk.components.Floor;
import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.components.PathType;
import com.jibestream.jmapandroidsdk.jcontroller.JController;
import com.jibestream.jmapandroidsdk.jcore.JCore;
import com.jibestream.jmapandroidsdk.rendering_engine.MapLayer;
import com.jibestream.jmapandroidsdk.rendering_engine.MapView;
import com.jibestream.jmapandroidsdk.rendering_engine.Stage;
import com.jibestream.jmapandroidsdk.rendering_engine.Transform;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.JDrawable;
import com.jibestream.jmapandroidsdk.rendering_engine.drawables.MapDrawable;
import com.jibestream.jmapandroidsdk.styles.JStyle;
import com.jibestream.mapuikit.Compass;
import com.jibestream.mapuikit.CompassOptions;
import com.jibestream.mapuikit.FloorButton;
import com.jibestream.mapuikit.FloorSelector;
import com.jibestream.mapuikit.FloorSelectorOptions;
import com.jibestream.mapuikit.PopupDrawable;
import com.jibestream.mapuikit.PopupDrawableOptions;
import com.jibestream.mapuikit.R;
import com.jibestream.mapuikit.Search;
import com.jibestream.mapuikit.SearchOptions;
import java.util.ArrayList;
import java.util.Arrays;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MapUiKit {
    private static final int SEARCH_QUERY_THRESHOLD = 1;
    private static final int TYPE_DESTINATION = 0;
    private static final int TYPE_AMENITY = 1;
    private static final int TYPE_PATH_TYPE = 2;
    private final JCore core;
    private final JController controller;
    private final Stage stage;
    private final Context context;
    private RelativeLayout uiContainer;
    private FloorSelector floorSelector;
    private Compass compass;
    private PopupDrawable popupDrawable;
    private Search search;
    private CompassOptions compassOptions;
    private final int DEFAULT_MARGIN = 20;
    private Techniques animationIn;
    private Techniques animationOut;
    private boolean allowConcurrentPopups;

    public MapUiKit(@NonNull JCore core, @NonNull JController controller) {
        this.core = core;
        this.controller = controller;
        this.stage = controller.getStage();
        this.context = controller.getContext();
        this.setupMapUIContainer();
    }

    public Compass renderCompass(final @NonNull CompassOptions compassOptions) {
        if (compassOptions == null) {
            return null;
        }
        this.compassOptions = compassOptions;
        boolean addView = false;
        if (this.compass == null) {
            this.compass = new Compass(this.context);
            this.compass.setId(R.id.map_ui_compass);
            addView = true;
        }
        this.compass.setOptions(compassOptions);
        if (compassOptions.icon == R.drawable.ic_compass && compassOptions.rotatedIcon != R.drawable.ic_rotated_compass) {
            compassOptions.icon = compassOptions.rotatedIcon;
        } else if (compassOptions.icon != R.drawable.ic_compass && compassOptions.rotatedIcon == R.drawable.ic_rotated_compass) {
            compassOptions.rotatedIcon = compassOptions.icon;
        }
        this.compass.setImageResource(compassOptions.icon);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.setMargins(20, 20, 20, 20);
        params.addRule(compassOptions.position[0]);
        params.addRule(compassOptions.position[1]);
        this.compass.setLayoutParams((ViewGroup.LayoutParams)params);
        this.controller.setOnRotateListener(new MapView.OnRotateListener(){

            public void onRotateChanged(float v) {
                final float delta = v - MapUiKit.this.compass.getRotation();
                MapUiKit.this.compass.post(new Runnable(){

                    @Override
                    public void run() {
                        if (((MapUiKit)MapUiKit.this).compass.isCompassNorth) {
                            MapUiKit.this.compass.setImageResource(compassOptions.rotatedIcon);
                            ((MapUiKit)MapUiKit.this).compass.isCompassNorth = false;
                        }
                        MapUiKit.this.compass.setRotation(MapUiKit.this.compass.getRotation() + delta);
                    }
                });
                if (MapUiKit.this.popupDrawable != null) {
                    float deltaPopup = -v;
                    MapUiKit.this.popupDrawable.setRotation(deltaPopup);
                }
            }
        });
        if (compassOptions.resetRotationOnTap) {
            this.compass.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Transform transform = new Transform();
                    transform.setRotate(0.0f);
                    MapUiKit.this.controller.setMapTransform(transform, 500, new MapView.OnAnimationCallback(){

                        public void onAnimationComplete() {
                            MapUiKit.this.compass.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MapUiKit.this.compass.setImageResource(compassOptions.icon);
                                    ((MapUiKit)MapUiKit.this).compass.isCompassNorth = true;
                                }
                            }, 300L);
                        }

                        public void onAnimationInterrupted() {
                        }
                    });
                }
            });
        }
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.compass);
                }
            });
        }
        return this.compass;
    }

    public Compass renderCompass() {
        return this.renderCompass(new CompassOptions());
    }

    public FloorSelector renderFloorSelector(@NonNull FloorSelectorOptions floorSelectorOptions) {
        ScrollView scrollView;
        if (floorSelectorOptions == null) {
            return null;
        }
        EventBus.getDefault().register((Object)this);
        boolean addView = false;
        if (this.floorSelector == null) {
            this.floorSelector = new FloorSelector(this.context);
            this.floorSelector.setId(R.id.map_ui_floor_selector);
            addView = true;
        }
        this.floorSelector.setOptions(floorSelectorOptions);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(floorSelectorOptions.position[0]);
        params.addRule(floorSelectorOptions.position[1]);
        this.floorSelector.setLayoutParams((ViewGroup.LayoutParams)params);
        LinearLayout floorButtonContainer = new LinearLayout(this.context);
        floorButtonContainer.setId(R.id.floor_container);
        boolean isVerticalBottom = false;
        boolean isHorizontalRight = false;
        if (floorSelectorOptions.vertical) {
            scrollView = new ScrollView(this.context);
            this.animationIn = Techniques.FadeInDown;
            this.animationOut = Techniques.FadeOutUp;
            this.floorSelector.setOrientation(1);
            floorButtonContainer.setOrientation(1);
            isVerticalBottom = floorSelectorOptions.position[1] == 12;
        } else {
            scrollView = new HorizontalScrollView(this.context);
            this.animationIn = Techniques.FadeInLeft;
            this.animationOut = Techniques.FadeOutLeft;
            this.floorSelector.setOrientation(0);
            floorButtonContainer.setOrientation(0);
            isHorizontalRight = floorSelectorOptions.position[0] == 11;
        }
        scrollView.setId(R.id.scroll_view);
        scrollView.setVisibility(4);
        LinearLayout.LayoutParams scrollViewParams = new LinearLayout.LayoutParams(-1, -2);
        scrollViewParams.weight = 1.0f;
        scrollView.setLayoutParams((ViewGroup.LayoutParams)scrollViewParams);
        scrollView.setPadding(0, 0, 0, 0);
        if (addView) {
            scrollView.post(new Runnable((FrameLayout)scrollView, floorButtonContainer){
                final /* synthetic */ FrameLayout val$scrollView;
                final /* synthetic */ LinearLayout val$floorButtonContainer;
                {
                    this.val$scrollView = frameLayout;
                    this.val$floorButtonContainer = linearLayout;
                }

                @Override
                public void run() {
                    this.val$scrollView.addView((View)this.val$floorButtonContainer);
                }
            });
        }
        if (isVerticalBottom || isHorizontalRight) {
            if (addView) {
                this.floorSelector.addView((View)scrollView, 0);
            }
            if (isVerticalBottom) {
                this.animationIn = Techniques.FadeInUp;
                this.animationOut = Techniques.FadeOutDown;
            } else {
                this.animationIn = Techniques.FadeInRight;
                this.animationOut = Techniques.FadeOutRight;
            }
        } else if (addView) {
            this.floorSelector.addView((View)scrollView);
        }
        this.setupSelectedFloorButton(floorSelectorOptions);
        if (addView) {
            this.setupFloorButtons(floorButtonContainer, floorSelectorOptions);
        }
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.floorSelector);
                }
            });
        }
        return this.floorSelector;
    }

    public FloorSelector renderFloorSelector() {
        return this.renderFloorSelector(new FloorSelectorOptions());
    }

    public Search renderSearch(final @NonNull SearchOptions searchOptions) {
        if (searchOptions == null) {
            return null;
        }
        boolean addView = false;
        if (this.search == null) {
            this.search = new Search(this.context);
            this.search.setId(R.id.map_ui_search);
            this.search.setIconified(false);
            this.search.clearFocus();
            addView = true;
        }
        this.search.setOptions(searchOptions);
        this.search.setQueryHint(searchOptions.hint);
        if (searchOptions.searchArray == null) {
            Destination[] destinations = this.controller.getActiveVenue().getDestinations().getAll();
            Amenity[] amenities = this.controller.getActiveVenue().getAmenities().getAll();
            PathType[] pathTypes = this.controller.getActiveVenue().getPathTypes().getAll();
            ArrayList<Object> baseModelArrayList = new ArrayList<Object>();
            baseModelArrayList.addAll(Arrays.asList(destinations));
            baseModelArrayList.addAll(Arrays.asList(amenities));
            baseModelArrayList.addAll(Arrays.asList(pathTypes));
            searchOptions.searchArray = new BaseModel[baseModelArrayList.size()];
            searchOptions.searchArray = baseModelArrayList.toArray(searchOptions.searchArray);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.search.setBackground(this.context.getDrawable(R.drawable.rounded_corner));
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.setMargins(20, 20, 20, 20);
        params.addRule(searchOptions.position);
        this.search.setLayoutParams((ViewGroup.LayoutParams)params);
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.search.findViewById(R.id.search_src_text);
        autoCompleteTextView.setThreshold(1);
        autoCompleteTextView.setImeOptions(0x10000000);
        ImageView closeButton = (ImageView)this.search.findViewById(R.id.search_close_btn);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EditText editText = (EditText)MapUiKit.this.search.findViewById(R.id.search_src_text);
                editText.setText((CharSequence)"");
                MapUiKit.this.search.setQuery("", false);
                MapUiKit.this.search.onActionViewCollapsed();
                MapUiKit.this.search.setIconified(false);
                MapUiKit.this.search.clearFocus();
                MapUiKit.this.hideKeyboard((Activity)MapUiKit.this.context);
                if (MapUiKit.this.controller != null) {
                    MapUiKit.this.controller.clearWayfindingPath();
                }
            }
        });
        this.search.post(new Runnable(){

            @Override
            public void run() {
                MapUiKit.this.search.setSuggestionsAdapter((CursorAdapter)new SimpleCursorAdapter(MapUiKit.this.context, 17367043, null, new String[]{"suggest_text_1"}, new int[]{16908308}, 2));
                MapUiKit.this.search.setOnSuggestionListener(new SearchView.OnSuggestionListener(){

                    public boolean onSuggestionSelect(int position) {
                        return false;
                    }

                    public boolean onSuggestionClick(int position) {
                        Cursor cursor = MapUiKit.this.search.getSuggestionsAdapter().getCursor();
                        cursor.moveToPosition(position);
                        int id2 = cursor.getInt(0);
                        int type = cursor.getInt(2);
                        Destination baseModel = null;
                        if (type == 0) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getDestinations().getById(id2);
                        } else if (type == 1) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getAmenities().getById(id2);
                        } else if (type == 2) {
                            baseModel = MapUiKit.this.controller.getActiveVenue().getPathTypes().getById(id2);
                        }
                        searchOptions.onItemClickListener.onItemClick((BaseModel)baseModel);
                        return false;
                    }
                });
            }
        });
        this.search.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return query.length() >= 1;
            }

            public boolean onQueryTextChange(String newText) {
                if (newText.length() >= 1) {
                    new FetchAutoCompleteSuggestionsTask().execute(new String[]{newText});
                }
                return true;
            }
        });
        if (addView) {
            this.uiContainer.post(new Runnable(){

                @Override
                public void run() {
                    MapUiKit.this.uiContainer.addView((View)MapUiKit.this.search);
                }
            });
        }
        return this.search;
    }

    public PopupDrawable renderPopup(@NonNull PopupDrawableOptions popupOptions) {
        if (popupOptions == null) {
            return null;
        }
        if (!this.allowConcurrentPopups) {
            for (MapDrawable mapDrawable : this.controller.getMapDrawables()) {
                MapLayer mapLayer = mapDrawable.getMapLayer("Popups");
                if (mapLayer == null) continue;
                mapLayer.clearCustomDrawables();
            }
        }
        this.popupDrawable = new PopupDrawable(popupOptions);
        this.popupDrawable.setOptions(popupOptions);
        this.controller.addComponent((JDrawable)this.popupDrawable, popupOptions.map != null ? popupOptions.map : this.controller.getCurrentMap(), popupOptions.coordinates, "Popups");
        this.popupDrawable.setRotation(-this.controller.getMapView().getCurrentRotation());
        this.controller.setOnRotateListener(new MapView.OnRotateListener(){

            public void onRotateChanged(float v) {
                float delta = -v;
                MapUiKit.this.popupDrawable.setRotation(delta);
                if (MapUiKit.this.compass != null) {
                    final float deltaCompass = v - MapUiKit.this.compass.getRotation();
                    MapUiKit.this.compass.post(new Runnable(){

                        @Override
                        public void run() {
                            if (((MapUiKit)MapUiKit.this).compass.isCompassNorth) {
                                MapUiKit.this.compass.setImageResource(((MapUiKit)MapUiKit.this).compassOptions.rotatedIcon);
                                ((MapUiKit)MapUiKit.this).compass.isCompassNorth = false;
                            }
                            MapUiKit.this.compass.setRotation(MapUiKit.this.compass.getRotation() + deltaCompass);
                        }
                    });
                }
            }
        });
        return this.popupDrawable;
    }

    public void setAllowConcurrentPopups(boolean allowConcurrentPopups) {
        this.allowConcurrentPopups = allowConcurrentPopups;
    }

    public RelativeLayout getUiContainer() {
        return this.uiContainer;
    }

    private void setupSelectedFloorButton(FloorSelectorOptions floorSelectorOptions) {
        Floor currentFloor = this.controller.getCurrentFloor();
        final FloorButton selectedFloorButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        selectedFloorButton.setMain(true);
        this.styleButton(selectedFloorButton, currentFloor, floorSelectorOptions.activeStyle, floorSelectorOptions.activeFontStyle);
        selectedFloorButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!selectedFloorButton.isSelected()) {
                    MapUiKit.this.expandFloorSelector();
                } else {
                    MapUiKit.this.collapseFloorSelector();
                }
            }
        });
    }

    private void collapseFloorSelector() {
        FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        mainButton.setSelected(false);
        FrameLayout scrollView = (FrameLayout)this.floorSelector.findViewById(R.id.scroll_view);
        YoYo.with((Techniques)this.animationOut).duration(700L).playOn((View)scrollView);
    }

    private void expandFloorSelector() {
        FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
        mainButton.setSelected(true);
        FrameLayout scrollView = (FrameLayout)this.floorSelector.findViewById(R.id.scroll_view);
        scrollView.setVisibility(0);
        YoYo.with((Techniques)this.animationIn).duration(700L).playOn((View)scrollView);
    }

    private void setupFloorButtons(final LinearLayout floorButtonContainer, final FloorSelectorOptions floorSelectorOptions) {
        Floor[] floors;
        for (final Floor floor : floors = this.controller.getCurrentBuilding().getFloors().getAll()) {
            final FloorButton floorButton = new FloorButton(this.context);
            this.styleButton(floorButton, floor, floorSelectorOptions.inactiveStyle, floorSelectorOptions.inactiveFontStyle);
            floorButtonContainer.post(new Runnable(){

                @Override
                public void run() {
                    if (floorSelectorOptions.position[1] == 12 || floorSelectorOptions.position[0] == 11) {
                        floorButtonContainer.addView((View)floorButton, 0);
                    } else {
                        floorButtonContainer.addView((View)floorButton);
                    }
                }
            });
            floorButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FloorButton mainButton = (FloorButton)MapUiKit.this.floorSelector.findViewById(R.id.main_floor_button);
                    mainButton.setText(floorButton.getText());
                    MapUiKit.this.collapseFloorSelector();
                    MapUiKit.this.controller.showMap(floor.getMap(), new JController.OnMapShownCallback(){

                        public void onBeforeMapShown(MapDrawable mapDrawable) {
                        }

                        public void onMapShown() {
                        }

                        public void onError(String s) {
                        }
                    });
                }
            });
        }
    }

    private void styleButton(FloorButton floorButton, Floor floor, JStyle style, JStyle fontStyle) {
        floorButton.setMapId(floor.getMap().getId());
        Drawable background = floorButton.getBackground();
        if (background instanceof ShapeDrawable) {
            ShapeDrawable shapeDrawable = (ShapeDrawable)background;
            shapeDrawable.getPaint().setColor(style.getColor());
        } else if (background instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)background;
            gradientDrawable.setColor(style.getColor());
            gradientDrawable.setStroke(style.getStrokeColor(), (int)style.getStrokeWidth());
        } else if (background instanceof ColorDrawable) {
            ColorDrawable colorDrawable = (ColorDrawable)background;
            colorDrawable.setColor(style.getColor());
        }
        floorButton.setText(floor.getShortName() != null ? floor.getShortName() : "");
        floorButton.setTextColor(fontStyle.getColor());
        floorButton.setTextSize(fontStyle.getTextSize());
    }

    private void setupMapUIContainer() {
        this.uiContainer = new RelativeLayout(this.context);
        this.uiContainer.setId(R.id.map_ui_container);
        this.uiContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.stage.post(new Runnable(){

            @Override
            public void run() {
                MapUiKit.this.stage.addView((View)MapUiKit.this.uiContainer);
            }
        });
    }

    @Subscribe
    public void onEvent(AnalyticsEvent event) {
        Floor currentFloor;
        Map map;
        if (event.getKey() == "JMAP_CONTROLLER_MAP_SHOW" && (map = this.controller.getActiveVenue().getMaps().getById(Integer.valueOf(event.getData("mapId")).intValue())) != null && (currentFloor = this.controller.getCurrentBuilding().getFloors().getByMap(map)) != null) {
            final FloorButton mainButton = (FloorButton)this.floorSelector.findViewById(R.id.main_floor_button);
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    mainButton.setText(currentFloor.getShortName());
                }
            });
        }
    }

    private void hideKeyboard(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private class FetchAutoCompleteSuggestionsTask
    extends AsyncTask<String, Void, Cursor> {
        private final String[] sAutocompleteColNames = new String[]{"_id", "suggest_text_1", "type"};

        private FetchAutoCompleteSuggestionsTask() {
        }

        protected Cursor doInBackground(String ... params) {
            Object[] baseModels = JController.getObjectsInArrayByString((Object[])((MapUiKit)MapUiKit.this).search.getOptions().searchArray, (String)params[0].toLowerCase(), null, (Integer)((MapUiKit)MapUiKit.this).search.getOptions().maxResults);
            MatrixCursor cursor = new MatrixCursor(this.sAutocompleteColNames);
            for (Object object : baseModels) {
                BaseModel baseModel = (BaseModel)object;
                String name = null;
                Integer type = null;
                if (baseModel instanceof Destination) {
                    name = ((Destination)baseModel).getName();
                    type = 0;
                } else if (baseModel instanceof Amenity) {
                    name = ((Amenity)baseModel).getName();
                    type = 1;
                } else if (baseModel instanceof PathType) {
                    name = ((PathType)baseModel).getName();
                    type = 2;
                }
                Object[] row = new Object[]{baseModel.getId(), name, type};
                cursor.addRow(row);
            }
            return cursor;
        }

        protected void onPostExecute(Cursor result) {
            MapUiKit.this.search.getSuggestionsAdapter().changeCursor(result);
        }
    }
}

