package com.jibestream.mapuikit;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.support.annotation.NonNull;

import com.jibestream.jmapandroidsdk.components.Map;
import com.jibestream.jmapandroidsdk.styles.JStyle;

/**
 * Created by Ken Pangilinan on 2018-03-29.
 */

public class PopupDrawableOptions {
    Map map;
    PointF coordinates;
    String titleText;
    JStyle titleTextStyle;
    String subText;
    JStyle subTextStyle;

    boolean showActionButton;
    JStyle actionButtonStyle;
    String actionButtonText;
    JStyle actionButtonTextStyle;
    JStyle popupStyle;

    Object metaData;

    /**
     * {@link PopupDrawable}' options.
     *
     * @param titleText   title of popup.
     * @param coordinates {@link PointF} on map.
     */
    public PopupDrawableOptions(@NonNull String titleText, @NonNull PointF coordinates) {
        this.titleText = titleText;
        this.coordinates = coordinates;

        if (titleTextStyle == null) {
            titleTextStyle = new JStyle();
            titleTextStyle.setAntiAlias(true);
            titleTextStyle.setColor(Color.BLACK); //black
        }

        if (subTextStyle == null) {
            subTextStyle = new JStyle();
            subTextStyle.setAntiAlias(true);
            subTextStyle.setColor(Color.BLACK);
        }

        if (popupStyle == null) {
            popupStyle = new JStyle();
            popupStyle.setAntiAlias(true);
            popupStyle.setColor(Color.WHITE); //white
        }

        if (actionButtonStyle == null) {
            actionButtonStyle = new JStyle();
            actionButtonStyle.setAntiAlias(true);
            actionButtonStyle.setColor(Color.parseColor("#E7423E")); //red
        }

        if (actionButtonTextStyle == null) {
            actionButtonTextStyle = new JStyle();
            actionButtonTextStyle.setAntiAlias(true);
            actionButtonTextStyle.setColor(Color.WHITE);
            actionButtonTextStyle.setTextAlign(Paint.Align.CENTER);
        }
    }

    /**
     * @param map Specify a specific map to place popup on, otherwise it will be placed on current map.
     */
    public void setMap(@NonNull Map map) {
        this.map = map;
    }

    /**
     * @param titleText Main/Title text for popup.
     */
    public void setTitleText(@NonNull String titleText) {
        this.titleText = titleText;
    }

    /**
     * @param titleTextStyle Title style.
     */
    public void setTitleTextStyle(@NonNull JStyle titleTextStyle) {
        this.titleTextStyle = titleTextStyle;
    }

    /**
     * @param subText Subtitle text for popup.
     */
    public void setSubText(@NonNull String subText) {
        this.subText = subText;
    }

    /**
     * @param subTextStyle Subtitle text style.
     */
    public void setSubTextStyle(@NonNull JStyle subTextStyle) {
        this.subTextStyle = subTextStyle;
    }

    /**
     * @param showActionButton {@code true} = show action button, {@code false} = hide action button.
     */
    public void setShowActionButton(boolean showActionButton) {
        this.showActionButton = showActionButton;
    }

    /**
     * @param actionButtonStyle Action button style.
     */
    public void setActionButtonStyle(@NonNull JStyle actionButtonStyle) {
        this.actionButtonStyle = actionButtonStyle;
    }

    /**
     * @param actionButtonText Action button text.
     */
    public void setActionButtonText(@NonNull String actionButtonText) {
        this.actionButtonText = actionButtonText;
    }

    /**
     * @param actionButtonTextStyle Action button text style.
     */
    public void setActionButtonTextStyle(@NonNull JStyle actionButtonTextStyle) {
        this.actionButtonTextStyle = actionButtonTextStyle;
    }

    /**
     * @param popupStyle Style of popup.
     */
    public void setPopupStyle(@NonNull JStyle popupStyle) {
        this.popupStyle = popupStyle;
    }

    /**
     * @return Extra data associated to the popup.
     */
    public Object getMetaData() {
        return metaData;
    }

    /**
     * @param metaData Set any extra data the popup may need.
     */
    public void setMetaData(@NonNull Object metaData) {
        this.metaData = metaData;
    }
}
