package com.jibestream.mapuikit;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.jibestream.jmapandroidsdk.components.Amenity;
import com.jibestream.jmapandroidsdk.components.BaseModel;
import com.jibestream.jmapandroidsdk.components.Destination;
import com.jibestream.jmapandroidsdk.components.PathType;

/**
 * Created by Ken Pangilinan on 2018-04-10.
 */

public class SearchArrayAdapter extends ArrayAdapter<BaseModel> {
    private final BaseModel[] items;

    public SearchArrayAdapter(Context context, BaseModel[] items) {
        super(context, 0, items);

        this.items = items;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;

        if (v == null) {
            LayoutInflater vi;
            vi = LayoutInflater.from(getContext());
            v = vi.inflate(android.R.layout.simple_list_item_1, null);
        }

        BaseModel baseModel = getItem(position);

        String name = null;
        if (baseModel instanceof Destination) {
            name = ((Destination) baseModel).getName();
        } else if (baseModel instanceof Amenity) {
            name = ((Amenity) baseModel).getName();
        } else if (baseModel instanceof PathType) {
            name = ((PathType) baseModel).getName();
        }

        if (name != null) {
            TextView textView = v.findViewById(android.R.id.text1);
            textView.setText(name.toString());
        }

        return v;
    }

    @Override
    public long getItemId(int position) {
        return getItem(position).getId();
    }
}
