package com.jibestream.mapuikit;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

/**
 * Created by Ken Pangilinan on 2018-04-17.
 */

public class FloorSelector extends LinearLayout {
    private FloorButton selectedFloorButton;
    private FloorSelectorOptions options;

    public FloorSelector(Context context) {
        super(context);

        init(context);
    }

    public FloorSelector(Context context, AttributeSet attrs) {
        super(context, attrs);

        init(context);
    }

    public FloorSelector(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init(context);
    }

    public void init(Context context) {
        final int PADDING = 25;
        setPadding(PADDING, PADDING, PADDING, PADDING);
        selectedFloorButton = new FloorButton(context);
        selectedFloorButton.setId(R.id.main_floor_button);

        addView(selectedFloorButton);
    }

    /**
     * @return Options for floor selector.
     */
    public FloorSelectorOptions getOptions() {
        return options;
    }

    /**
     * @param options Set options for floor selector.
     */
    public void setOptions(@NonNull FloorSelectorOptions options) {
        this.options = options;
    }

    /**
     * @return Selected floor button.
     */
    public FloorButton getSelectedFloorButton() {
        return selectedFloorButton;
    }
}
