package com.jibestream.assetkit;

import android.graphics.PointF;

import com.jibestream.jmapandroidsdk.rendering_engine.MapView;
import com.jibestream.jmapandroidsdk.rendering_engine.moving_objects.MovingObject;

/**
 * Created by louieyuen on 2017-03-27.
 */

public class Asset extends MovingObject {
    private String type;

    /**
     * Constructor for creating an {@link Asset} on {@link MapView} with a unique ID and type.
     *
     * @param type The type string for displaying assets.
     */
    public Asset(String type) {
        this(type, new PointF());
    }

    /**
     * Constructor for creating an {@link Asset} on {@link MapView} with a unique ID and type.
     *
     * @param type The type string for displaying assets.
     */
    public Asset(String type, PointF position) {
        this(type, position, -1);
    }

    /**
     * Constructor for creating an {@link Asset} on {@link MapView} with a unique ID and type.
     *
     * @param type The type string for displaying assets.
     */
    public Asset(String type, PointF position, int id) {
        super(position.x, position.y);

        this.type = type;

        if (id != -1) {
            setId(id);
        }
    }

    /**
     * Gets the type of the {@link Asset}.
     *
     * @return The type string associated to the asset.
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the type of the {@link Asset}.
     *
     * @param type The type string set for the asset.
     */
    public void setType(String type) {
        this.type = type;
    }
}
