/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.components.ButtonBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.components.Form;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="submit", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.SubmitTag", description="Render a submit button", allowDynamicAttributes=true)
public class Submit
extends AbstractRemoteBean
implements ButtonBean {
    public static final String TEMPLATE = "submit";
    public static final String TEMPLATE_CLOSE = "submit-close";
    public static final String JQUERYACTION = "button";
    public static final String COMPONENT_NAME = Submit.class.getName();
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_SRC = "src";
    private static final String PARAM_CLEAR_FORM = "clearForm";
    private static final String PARAM_RESET_FORM = "resetForm";
    private static final String PARAM_IFRAME = "iframe";
    private static final String PARAM_ON_CLICK_TOPICS = "onClickTopics";
    private static final String PARAM_OPEN_DIALOG = "openDialog";
    private static final String PARAM_OPEN_DIALOG_TITLE = "openDialogTitle";
    private static final String PARAM_BUTTON = "button";
    private static final String PARAM_BUTTON_ICON = "buttonIcon";
    private static final String PARAM_BUTTON_ICON_SECONDARY = "buttonIconSecondary";
    private static final String PARAM_BUTTON_TEXT = "buttonText";
    private static final String PARAM_VALIDATE = "validate";
    private static final String PARAM_VALIDATE_FUNCTION = "validateFunction";
    private static final String PARAM_FORM_FILTER = "formFilter";
    private static final String PARAM_REPLACE_TARGET = "replaceTarget";
    private static final String PARAM_PARENT_THEME = "parentTheme";
    private static final String PARAM_FORM_IDS = "formIds";
    private static final String PARAM_BODY = "body";
    private static final String ID_PREFIX_SUBMIT = "submit_";
    protected String src;
    protected String type;
    protected String clearForm;
    protected String resetForm;
    protected String iframe;
    protected String onClickTopics;
    protected String openDialog;
    protected String openDialogTitle;
    protected String parentTheme;
    protected String button;
    protected String buttonIcon;
    protected String buttonIconSecondary;
    protected String buttonText;
    protected String validate;
    protected String validateFunction;
    protected String formFilter;
    protected String replaceTarget;

    public Submit(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void evaluateParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", "button");
        if (this.key == null && this.value == null) {
            this.value = "Submit";
        }
        if (this.key != null && this.value == null) {
            this.value = "%{getText('" + this.key + "')}";
        }
        super.evaluateParams();
    }

    @Override
    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameterIfPresent(PARAM_TYPE, this.type);
        this.addParameterIfPresent(PARAM_SRC, this.src);
        this.addParameterIfPresent(PARAM_CLEAR_FORM, this.clearForm, Boolean.class);
        this.addParameterIfPresent(PARAM_RESET_FORM, this.resetForm, Boolean.class);
        this.addParameterIfPresent(PARAM_IFRAME, this.iframe, Boolean.class);
        this.addParameterIfPresent(PARAM_ON_CLICK_TOPICS, this.onClickTopics);
        this.addParameterIfPresent(PARAM_OPEN_DIALOG, this.openDialog);
        this.addParameterIfPresent(PARAM_OPEN_DIALOG_TITLE, this.openDialogTitle);
        this.addParameterIfPresent("button", this.button, Boolean.class);
        this.addParameterIfPresent(PARAM_BUTTON_ICON, this.buttonIcon);
        this.addParameterIfPresent(PARAM_BUTTON_ICON_SECONDARY, this.buttonIconSecondary);
        this.addParameterIfPresent(PARAM_BUTTON_TEXT, this.buttonText, Boolean.class);
        this.addParameterIfPresent(PARAM_VALIDATE, this.validate, Boolean.class);
        this.addParameterIfPresent(PARAM_VALIDATE_FUNCTION, this.validateFunction);
        this.addParameterIfPresent(PARAM_FORM_FILTER, this.formFilter);
        this.addParameterIfPresent(PARAM_REPLACE_TARGET, this.replaceTarget, Boolean.class);
        this.addGeneratedIdParam(ID_PREFIX_SUBMIT);
        Form form = (Form)this.findAncestor(Form.class);
        if (this.parentTheme != null) {
            this.addParameter(PARAM_PARENT_THEME, this.findString(this.parentTheme));
        } else if (form != null) {
            this.addParameter(PARAM_PARENT_THEME, form.getTheme());
        } else {
            this.addParameter(PARAM_PARENT_THEME, "simple");
        }
        if (form != null && StringUtils.isBlank((CharSequence)this.formIds)) {
            this.addParameter(PARAM_FORM_IDS, form.getId());
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    protected boolean supportsImageType() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        this.evaluateParams();
        try {
            this.addParameter(PARAM_BODY, body);
            this.mergeTemplate(writer, this.buildTemplateName(this.template, this.getDefaultTemplate()));
        }
        catch (Exception exception) {
        }
        finally {
            this.popComponentStack();
        }
        return false;
    }

    @StrutsTagAttribute(description="The type of submit to use. Valid values are <i>input</i>, <i>button</i> and <i>image</i>.", defaultValue="input")
    public void setType(String type) {
        this.type = type;
    }

    @StrutsTagAttribute(description="Supply an image src for <i>image</i> type submit button. Will have no effect for types <i>input</i> and <i>button</i>.")
    public void setSrc(String src) {
        this.src = src;
    }

    @StrutsTagAttribute(description="Clear all form fields after successful submit. Default: false", type="Boolean")
    public void setClearForm(String clearForm) {
        this.clearForm = clearForm;
    }

    @StrutsTagAttribute(description="Reset the form after successful submit. Default: false", type="Boolean")
    public void setResetForm(String resetForm) {
        this.resetForm = resetForm;
    }

    @StrutsTagAttribute(description="Boolean flag indicating whether the form should always target the server response to an iframe. This is useful in conjuction with file uploads. Default: false", type="Boolean")
    public void setIframe(String iframe) {
        this.iframe = iframe;
    }

    @StrutsTagAttribute(name="onClickTopics", description="A comma delimited list of topics that published when the element is clicked")
    public void setOnClickTopics(String onClickTopics) {
        this.onClickTopics = onClickTopics;
    }

    @StrutsTagAttribute(description="id of dialog that will be opened when clicked.")
    public void setOpenDialog(String openDialog) {
        this.openDialog = openDialog;
    }

    @StrutsTagAttribute(description="Set the title of a dialog opened by openDialog or openDialogTopics")
    public void setOpenDialogTitle(String openDialogTitle) {
        this.openDialogTitle = openDialogTitle;
    }

    @StrutsTagAttribute(description="The parent theme. Default: value of parent form tag or simple if no parent form tag is available")
    public void setParentTheme(String parentTheme) {
        this.parentTheme = parentTheme;
    }

    @Override
    @StrutsTagAttribute(description="jQuery UI Button", defaultValue="false", type="Boolean")
    public void setButton(String button) {
        this.button = button;
    }

    @Override
    @StrutsTagAttribute(description="Icons to display. The primary icon is displayed on the left of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIcon(String buttonIcon) {
        this.buttonIcon = buttonIcon;
    }

    @Override
    @StrutsTagAttribute(description="Icons to display. The secondary icon is displayed on the right of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIconSecondary(String buttonIconSecondary) {
        this.buttonIconSecondary = buttonIconSecondary;
    }

    @Override
    @StrutsTagAttribute(description="Whether to show any text - when set to false (display no text), icons (see icons option) must be enabled, otherwise it'll be ignored.", defaultValue="true", type="Boolean")
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    @StrutsTagAttribute(description="A function that handle the client validation result. eg.: myValidation(form, errors)")
    public void setValidateFunction(String validateFunction) {
        this.validateFunction = validateFunction;
    }

    @StrutsTagAttribute(description="Enable client AJAX validation", defaultValue="false", type="Boolean")
    public void setValidate(String validate) {
        this.validate = validate;
    }

    @StrutsTagAttribute(description="Function name used to filter the fields of the form.")
    public void setFormFilter(String formFilter) {
        this.formFilter = formFilter;
    }

    @StrutsTagAttribute(description="Set to true if the target should be replaced or false if only the target contents should be replaced.", defaultValue="false", type="Boolean")
    public void setReplaceTarget(String replaceTarget) {
        this.replaceTarget = replaceTarget;
    }
}

