/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormListElement;
import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="autocompleter", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.AutocompleterTag", description="Render a jQuery UI Autocompleter", allowDynamicAttributes=true)
public class Autocompleter
extends AbstractFormListElement {
    public static final String JQUERYACTION = "autocompleter";
    public static final String TEMPLATE = "autocompleter-close";
    public static final String OPEN_TEMPLATE = "autocompleter";
    private static final String PARAM_DELAY = "delay";
    private static final String PARAM_LOAD_MINIMUM_COUNT = "loadMinimumCount";
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_MAXLENGTH = "maxlength";
    private static final String PARAM_SELECT_BOX = "selectBox";
    private static final String PARAM_SELECT_BOX_ICON = "selectBoxIcon";
    private static final String PARAM_READONLY = "readonly";
    private static final String PARAM_MULTIPLE = "multiple";
    private static final String PARAM_ON_SELECT_TOPICS = "onSelectTopics";
    private static final String PARAM_ON_FOCUS_TOPICS = "onFocusTopics";
    private static final String PARAM_ON_SEARCH_TOPICS = "onSearchTopics";
    private static final String PARAM_LIST_LABEL = "listLabel";
    private static final String PARAM_FORCE_VALID_OPTION = "forceValidOption";
    private static final String PARAM_AUTO_FOCUS = "autoFocus";
    private static final String PARAM_WIDGET_ID = "widgetid";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_WIDGET_NAME = "widgetname";
    private static final String PARAM_VALUE_WIDGET = "valueWidget";
    private static final String SUFFIX_WIDGET = "_widget";
    private static final String ID_PREFIX_AUTOCOMPLETER = "autocompleter_";
    protected String delay;
    protected String loadMinimumCount;
    protected String selectBox;
    protected String selectBoxIcon;
    protected String onSelectTopics;
    protected String onFocusTopics;
    protected String onSearchTopics;
    protected String maxlength;
    protected String readonly;
    protected String size;
    protected String multiple;
    protected String listLabel;
    protected String forceValidOption;
    protected String autoFocus;
    protected String valueWidget;

    public Autocompleter(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return "autocompleter";
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateParams() {
        super.evaluateParams();
        this.addParameter("jqueryaction", "autocompleter");
        if (this.getParameters().get("list") != null) {
            this.addParameter("emptyOption", true);
        }
        this.addParameterIfPresent(PARAM_DELAY, this.delay, Integer.class);
        this.addParameterIfPresent(PARAM_LOAD_MINIMUM_COUNT, this.loadMinimumCount, Integer.class);
        this.addParameterIfPresent(PARAM_SIZE, this.size);
        this.addParameterIfPresent(PARAM_MAXLENGTH, this.maxlength);
        this.addParameterIfPresent(PARAM_SELECT_BOX, this.selectBox, Boolean.class);
        this.addParameterIfPresent(PARAM_SELECT_BOX_ICON, this.selectBoxIcon, Boolean.class);
        this.addParameterIfPresent(PARAM_READONLY, this.readonly, Boolean.class);
        this.addParameterIfPresent(PARAM_MULTIPLE, this.multiple, Boolean.class);
        this.addParameterIfPresent(PARAM_ON_SELECT_TOPICS, this.onSelectTopics);
        this.addParameterIfPresent(PARAM_ON_FOCUS_TOPICS, this.onFocusTopics);
        this.addParameterIfPresent(PARAM_ON_SEARCH_TOPICS, this.onSearchTopics);
        this.addParameterIfPresent(PARAM_SIZE, this.size);
        this.addParameterIfPresent(PARAM_FORCE_VALID_OPTION, this.forceValidOption, Boolean.class);
        this.addParameterIfPresent(PARAM_AUTO_FOCUS, this.autoFocus, Boolean.class);
        if (this.listLabel != null) {
            this.addParameter(PARAM_LIST_LABEL, this.stripExpressionIfAltSyntax(this.listLabel));
        }
        this.addGeneratedIdParam(ID_PREFIX_AUTOCOMPLETER);
        this.addParameter("id", this.id + SUFFIX_WIDGET);
        this.addParameter(PARAM_WIDGET_ID, this.id);
        String nameValue = (String)this.getParameters().get(PARAM_NAME);
        this.addParameter(PARAM_NAME, nameValue + SUFFIX_WIDGET);
        this.addParameter(PARAM_WIDGET_NAME, nameValue);
        if (this.valueWidget != null) {
            this.addParameter(PARAM_VALUE_WIDGET, this.findString(this.valueWidget));
        } else if (this.value != null) {
            this.addParameter(PARAM_VALUE_WIDGET, this.findString(this.value));
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Delay before making the search", type="Integer", defaultValue="300")
    public void setDelay(String delay) {
        this.delay = delay;
    }

    @StrutsTagAttribute(description="Minimum number of characters that will force the content to be loaded", type="Integer", defaultValue="1")
    public void setLoadMinimumCount(String loadMinimumCount) {
        this.loadMinimumCount = loadMinimumCount;
    }

    @StrutsTagAttribute(description="Use an Select Box as Autocompleter", defaultValue="false", type="Boolean")
    public void setSelectBox(String selectBox) {
        this.selectBox = selectBox;
    }

    @StrutsTagAttribute(description="display the select box icon", type="Boolean", defaultValue="false")
    public void setSelectBoxIcon(String selectBoxIcon) {
        this.selectBoxIcon = selectBoxIcon;
    }

    @StrutsTagAttribute(description="A comma delimited list of topics that published when item is selected")
    public void setOnSelectTopics(String onSelectTopics) {
        this.onSelectTopics = onSelectTopics;
    }

    @Override
    @StrutsTagAttribute(description="A comma delimited list of topics that published before focus is moved to an item")
    public void setOnFocusTopics(String onFocusTopics) {
        this.onFocusTopics = onFocusTopics;
    }

    @StrutsTagAttribute(description="A comma delimited list of topics that published before a request is started, after loadMinimumCount and delay are met.")
    public void setOnSearchTopics(String onSearchTopics) {
        this.onSearchTopics = onSearchTopics;
    }

    @StrutsTagAttribute(description="HTML maxlength attribute", type="Integer")
    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    @StrutsTagAttribute(description="Whether the input is readonly", type="Boolean", defaultValue="false")
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    @StrutsTagAttribute(description="HTML size attribute", type="Integer")
    public void setSize(String size) {
        this.size = size;
    }

    @StrutsTagAttribute(description=" Creates a multiple select. The tag will pre-select multiple values if the values are passed as an Array or a Collection(of appropriate types) via the value attribute. If one of the keys equals one of the values in the Collection or Array it wil be selected", type="Boolean", defaultValue="false")
    public void setMultiple(String multiple) {
        this.multiple = multiple;
    }

    @StrutsTagAttribute(description="a seperate label element.")
    public void setListLabel(String listLabel) {
        this.listLabel = listLabel;
    }

    @StrutsTagAttribute(description="Force selection to be one of the options.", defaultValue="true", type="Boolean")
    public void setForceValidOption(String forceValidOption) {
        this.forceValidOption = forceValidOption;
    }

    @StrutsTagAttribute(description="If set to true the first item will be automatically focused.", defaultValue="false", type="Boolean")
    public void setAutoFocus(String autoFocus) {
        this.autoFocus = autoFocus;
    }

    @StrutsTagAttribute(description="The value of the Widget Input Field.")
    public void setValueWidget(String valueWidget) {
        this.valueWidget = valueWidget;
    }
}

