/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.MultipleBintrayCallException;
import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.Attribute;
import com.jfrog.bintray.client.api.details.VersionDetails;
import com.jfrog.bintray.client.api.handle.PackageHandle;
import com.jfrog.bintray.client.api.handle.VersionHandle;
import com.jfrog.bintray.client.api.model.Version;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import com.jfrog.bintray.client.impl.model.VersionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionHandleImpl
implements VersionHandle {
    private static final Logger log = LoggerFactory.getLogger(VersionHandleImpl.class);
    private static final String OVERRIDE_HEADER = "X-Bintray-Override";
    private static final String DEB_DIST_HEADER = "X-Bintray-Debian-Distribution";
    private static final String DEB_COMP_HEADER = "X-Bintray-Debian-Component";
    private static final String DEB_ARCH_HEADER = "X-Bintray-Debian-Architecture";
    private BintrayImpl bintrayHandle;
    private String name;
    private PackageHandle packageHandle;

    public VersionHandleImpl(BintrayImpl bintrayHandle, PackageHandle packageHandle, String versionName) {
        this.bintrayHandle = bintrayHandle;
        this.packageHandle = packageHandle;
        this.name = versionName;
    }

    public PackageHandle pkg() {
        return this.packageHandle;
    }

    public String name() {
        return this.name;
    }

    public Version get() throws BintrayCallException, IOException {
        VersionDetails versionDetails;
        HttpResponse response = this.bintrayHandle.get(this.getVersionUri(), null);
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            InputStream jsonContentStream = response.getEntity().getContent();
            versionDetails = (VersionDetails)mapper.readValue(jsonContentStream, VersionDetails.class);
        }
        catch (IOException e) {
            log.debug("{}", (Throwable)e);
            log.error("Can't process the json file: {}", (Object)e.getMessage());
            throw e;
        }
        return new VersionImpl(versionDetails);
    }

    public VersionHandle update(VersionDetails versionDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = VersionImpl.getCreateUpdateJson(versionDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getVersionUri(), headers, IOUtils.toInputStream((String)jsonContent));
        return this.updateAttributes(versionDetails);
    }

    public VersionHandle delete() throws BintrayCallException {
        this.bintrayHandle.delete(this.getVersionUri(), null);
        return this;
    }

    public boolean exists() throws BintrayCallException {
        try {
            this.bintrayHandle.head(this.getVersionUri(), null);
        }
        catch (BintrayCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public VersionHandle setAttributes(VersionDetails versionDetails) throws IOException, BintrayCallException {
        return this.setAttributes(versionDetails.getAttributes());
    }

    public VersionHandle setAttributes(List<Attribute> attributes) throws IOException, BintrayCallException {
        if (attributes == null) {
            return this;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = Attribute.getJsonFromAttributeList(attributes);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.post(this.getVersionUri() + "/attributes", headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public VersionHandle updateAttributes(VersionDetails versionDetails) throws IOException, BintrayCallException {
        return this.updateAttributes(versionDetails.getAttributes());
    }

    public VersionHandle updateAttributes(List<Attribute> attributes) throws IOException, BintrayCallException {
        if (attributes == null) {
            return this;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = Attribute.getJsonFromAttributeList(attributes);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getVersionUri() + "/attributes", headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public VersionHandle upload(Map<String, InputStream> content) throws MultipleBintrayCallException {
        return this.upload(content, false);
    }

    public VersionHandle upload(Map<String, InputStream> content, boolean overrideExisting) throws MultipleBintrayCallException {
        HashMap<String, InputStream> uriConvertedContent = new HashMap<String, InputStream>();
        for (String path : content.keySet()) {
            uriConvertedContent.put(this.getUploadUriWithPath(path), content.get(path));
        }
        Map<String, String> headers = null;
        if (overrideExisting) {
            headers = this.getOverrideHeader();
        }
        this.bintrayHandle.putBinary(uriConvertedContent, headers);
        return this;
    }

    public VersionHandle upload(String path, InputStream content) throws BintrayCallException {
        return this.upload(path, content, false);
    }

    public VersionHandle upload(String path, InputStream content, boolean overrideExisting) throws BintrayCallException {
        Map<String, String> headers = null;
        if (overrideExisting) {
            headers = this.getOverrideHeader();
        }
        this.bintrayHandle.putBinary(this.getUploadUriWithPath(path), headers, content);
        return this;
    }

    public VersionHandle uploadVagrant(String path, String boxProvider, InputStream content) throws BintrayCallException {
        return this.uploadVagrant(path, boxProvider, content, false);
    }

    public VersionHandle uploadVagrant(String path, String boxProvider, InputStream content, boolean overrideExisting) throws BintrayCallException {
        Map<String, String> headers = null;
        if (overrideExisting) {
            headers = this.getOverrideHeader();
        }
        this.bintrayHandle.putBinary(this.getVagrantUploadUri(path, boxProvider), headers, content);
        return this;
    }

    public VersionHandle uploadDebian(String path, String distribution, String component, String architecture, InputStream content) throws BintrayCallException {
        return this.uploadDebian(path, distribution, component, architecture, content, false);
    }

    public VersionHandle uploadDebian(String path, String distribution, String component, String architecture, InputStream content, boolean overrideExisting) throws BintrayCallException {
        Map<String, String> headers = this.getDebianCoordinatesHeaders(distribution, component, architecture);
        if (overrideExisting) {
            headers.putAll(this.getOverrideHeader());
        }
        this.bintrayHandle.putBinary(this.getUploadUriWithPath(path), headers, content);
        return this;
    }

    public VersionHandle uploadDebian(String path, List<String> distributions, List<String> components, List<String> architectures, InputStream content) throws BintrayCallException {
        return this.uploadDebian(path, distributions, components, architectures, content, false);
    }

    public VersionHandle uploadDebian(String path, List<String> distributions, List<String> components, List<String> architectures, InputStream content, boolean overrideExisting) throws BintrayCallException {
        Map<String, String> headers = this.getDebianCoordinatesHeaders(distributions, components, architectures);
        if (overrideExisting) {
            headers.putAll(this.getOverrideHeader());
        }
        this.bintrayHandle.putBinary(this.getUploadUriWithPath(path), headers, content);
        return this;
    }

    public VersionHandle publish() throws BintrayCallException {
        return this.publish(null);
    }

    public VersionHandle publish(String gpgPassphrase) throws BintrayCallException {
        HashMap<String, String> headers = null;
        if (StringUtils.isNotBlank((String)gpgPassphrase)) {
            headers = new HashMap<String, String>();
            headers.put("X-GPG-PASSPHRASE", gpgPassphrase);
        }
        this.bintrayHandle.post(this.getCurrentVersionContentUri() + "/publish", headers);
        return this;
    }

    public VersionHandle publishSync() throws BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        BintrayImpl.addContentTypeJsonHeader(headers);
        int timeout = -1;
        String wait = "{\"publish_wait_for_secs\":" + timeout + "}";
        this.bintrayHandle.post(this.getCurrentVersionContentUri() + "/publish", headers, IOUtils.toInputStream((String)wait));
        return this;
    }

    public VersionHandle discard() throws BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        BintrayImpl.addContentTypeJsonHeader(headers);
        String discard = "{\n\"discard\":true\n}";
        this.bintrayHandle.post(this.getCurrentVersionContentUri() + "/publish", headers, IOUtils.toInputStream((String)discard));
        return this;
    }

    public VersionHandle sign(int fileCount) throws BintrayCallException {
        return this.sign(null, fileCount);
    }

    public VersionHandle sign(String passphrase, int fileCount) throws BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (passphrase != null && !passphrase.equals("")) {
            headers.put("X-GPG-PASSPHRASE", passphrase);
        }
        this.bintrayHandle.sign(this.getCurrentVersionGpgUri(), headers, fileCount);
        return null;
    }

    public String getVersionUri() {
        return "packages/" + this.getCurrentVersionFullyQualifiedUri();
    }

    public String getCurrentVersionGpgUri() {
        return "gpg/" + this.getCurrentVersionFullyQualifiedUri();
    }

    public String getCurrentVersionContentUri() {
        return String.format("content/%s/%s/%s/%s", this.packageHandle.repository().owner().name(), this.packageHandle.repository().name(), this.packageHandle.name(), this.name);
    }

    private String getCurrentVersionFullyQualifiedUri() {
        return String.format("%s/%s/%s/versions/%s", this.packageHandle.repository().owner().name(), this.packageHandle.repository().name(), this.packageHandle.name(), this.name);
    }

    private String getVagrantUploadUri(String path, String boxProvider) {
        return this.getUploadUriWithPath(path) + "?box_provider=" + boxProvider;
    }

    private String getUploadUriWithPath(String path) {
        return this.getCurrentVersionContentUri() + "/" + path;
    }

    private Map<String, String> getDebianCoordinatesHeaders(List<String> distributions, List<String> components, List<String> architectures) {
        return this.getDebianCoordinatesHeaders(StringUtils.join(distributions, (String)","), StringUtils.join(components, (String)","), StringUtils.join(architectures, (String)","));
    }

    private Map<String, String> getDebianCoordinatesHeaders(String distribution, String component, String architecture) {
        HashMap<String, String> coordinatesHeaders = new HashMap<String, String>();
        coordinatesHeaders.put(DEB_DIST_HEADER, distribution);
        coordinatesHeaders.put(DEB_COMP_HEADER, component);
        coordinatesHeaders.put(DEB_ARCH_HEADER, architecture);
        return coordinatesHeaders;
    }

    private Map<String, String> getOverrideHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(OVERRIDE_HEADER, "1");
        return headers;
    }
}

