/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.ObjectMapperHelper;
import com.jfrog.bintray.client.api.details.PackageDetails;
import com.jfrog.bintray.client.api.details.RepositoryDetails;
import com.jfrog.bintray.client.api.handle.AttributesSearchQuery;
import com.jfrog.bintray.client.api.handle.PackageHandle;
import com.jfrog.bintray.client.api.handle.RepositoryHandle;
import com.jfrog.bintray.client.api.handle.SubjectHandle;
import com.jfrog.bintray.client.api.model.Pkg;
import com.jfrog.bintray.client.api.model.Repository;
import com.jfrog.bintray.client.impl.handle.AttributesSearchQueryImpl;
import com.jfrog.bintray.client.impl.handle.BintrayImpl;
import com.jfrog.bintray.client.impl.handle.PackageHandleImpl;
import com.jfrog.bintray.client.impl.handle.SubjectHandleImpl;
import com.jfrog.bintray.client.impl.model.PackageImpl;
import com.jfrog.bintray.client.impl.model.RepositoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryHandleImpl
implements RepositoryHandle {
    private static final Logger log = LoggerFactory.getLogger(RepositoryHandleImpl.class);
    private BintrayImpl bintrayHandle;
    private SubjectHandleImpl owner;
    private String name;
    private AttributesSearchQueryImpl searchQuery = null;

    public RepositoryHandleImpl(BintrayImpl bintrayHandle, SubjectHandleImpl owner, String repoName) {
        this.bintrayHandle = bintrayHandle;
        this.owner = owner;
        this.name = repoName;
    }

    public SubjectHandle owner() {
        return this.owner;
    }

    public Repository get() throws IOException, BintrayCallException {
        RepositoryDetails repoDetails;
        HttpResponse response = this.bintrayHandle.get(this.getRepositoryUri(), null);
        InputStream jsonContentStream = response.getEntity().getContent();
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            repoDetails = (RepositoryDetails)mapper.readValue(jsonContentStream, RepositoryDetails.class);
        }
        catch (IOException e) {
            log.error("Can't parse the json file: " + e.getMessage());
            throw e;
        }
        return new RepositoryImpl(repoDetails);
    }

    public RepositoryHandle update(RepositoryDetails repositoryDetails) throws IOException, BintrayCallException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String jsonContent = RepositoryImpl.getUpdateJson(repositoryDetails);
        BintrayImpl.addContentTypeJsonHeader(headers);
        this.bintrayHandle.patch(this.getRepositoryUri(), headers, IOUtils.toInputStream((String)jsonContent));
        return this;
    }

    public PackageHandle pkg(String packageName) {
        return new PackageHandleImpl(this.bintrayHandle, this, packageName);
    }

    public PackageHandle createPkg(PackageDetails packageDetails) throws IOException, BintrayCallException {
        String jsonContent = PackageImpl.getCreateUpdateJson(packageDetails);
        this.bintrayHandle.post(String.format("packages/%s/%s", this.owner.name(), this.name), null, IOUtils.toInputStream((String)jsonContent));
        return new PackageHandleImpl(this.bintrayHandle, this, packageDetails.getName()).setAttributes(packageDetails);
    }

    public AttributesSearchQuery searchForPackage() {
        return new AttributesSearchQueryImpl(this);
    }

    public RepositoryHandle delete() throws BintrayCallException {
        this.bintrayHandle.delete(this.getRepositoryUri(), null);
        return this;
    }

    public String name() {
        return this.name;
    }

    public boolean exists() throws BintrayCallException {
        try {
            this.bintrayHandle.head(this.getRepositoryUri(), null);
        }
        catch (BintrayCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public String getRepositoryUri() {
        return String.format("repos/%s/%s", this.owner.name(), this.name);
    }

    public void addQuery(AttributesSearchQueryImpl query) {
        this.searchQuery = query;
    }

    public List<Pkg> attributeSearch() throws IOException, BintrayCallException {
        ObjectMapper mapper = ObjectMapperHelper.get();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, (Object)this.searchQuery);
        }
        catch (IOException e) {
            log.error("Error writing search query to json: ", (Throwable)e);
            throw e;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.bintrayHandle.post("/search/attributes/" + this.owner.name() + "/" + this.name, headers, IOUtils.toInputStream((String)writer.toString()));
        List answer = (List)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<List<PackageDetails>>(){});
        ArrayList<Pkg> packages = new ArrayList<Pkg>();
        for (PackageDetails pkgDetails : answer) {
            packages.add(new PackageImpl(pkgDetails));
        }
        this.searchQuery = null;
        return packages;
    }
}

