/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.impl.handle;

import com.jfrog.bintray.client.api.BintrayCallException;
import com.jfrog.bintray.client.api.details.Attribute;
import com.jfrog.bintray.client.api.handle.AttributesSearchQuery;
import com.jfrog.bintray.client.api.handle.AttributesSearchQueryClause;
import com.jfrog.bintray.client.api.model.Pkg;
import com.jfrog.bintray.client.api.model.Version;
import com.jfrog.bintray.client.impl.handle.AttributesSearchQueryClauseImpl;
import com.jfrog.bintray.client.impl.handle.PackageHandleImpl;
import com.jfrog.bintray.client.impl.handle.RepositoryHandleImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=AttributeSearchQuerySerializer.class)
class AttributesSearchQueryImpl
implements AttributesSearchQuery {
    private final RepositoryHandleImpl repositoryHandle;
    private final PackageHandleImpl packageHandle;
    private String attributeName;
    private List<AttributesSearchQueryClauseImpl> queryClauses = new ArrayList<AttributesSearchQueryClauseImpl>();

    public AttributesSearchQueryImpl(RepositoryHandleImpl repositoryHandle) {
        this.repositoryHandle = repositoryHandle;
        this.packageHandle = null;
    }

    public AttributesSearchQueryImpl(PackageHandleImpl packageHandle) {
        this.packageHandle = packageHandle;
        this.repositoryHandle = null;
    }

    public void addQueryClause(AttributesSearchQueryClauseImpl clause) {
        this.queryClauses.add(clause);
    }

    public List<AttributesSearchQueryClauseImpl> getQueryClauses() {
        return this.queryClauses;
    }

    public AttributesSearchQueryClause byAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return new AttributesSearchQueryClauseImpl(this);
    }

    public List<Pkg> searchPackage() throws IOException, BintrayCallException {
        this.repositoryHandle.addQuery(this);
        return this.repositoryHandle.attributeSearch();
    }

    public List<Version> searchVersion() throws IOException, BintrayCallException {
        this.packageHandle.addQuery(this);
        return this.packageHandle.attributeSearch();
    }

    public static class AttributeSearchQuerySerializer
    extends JsonSerializer<AttributesSearchQueryImpl> {
        public void serialize(AttributesSearchQueryImpl value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            jgen.writeStartObject();
            jgen.writeArrayFieldStart(value.attributeName);
            List<AttributesSearchQueryClauseImpl> clauses = value.getQueryClauses();
            for (AttributesSearchQueryClauseImpl clause : clauses) {
                if (clause.getType().equals((Object)Attribute.Type.Boolean)) {
                    jgen.writeBoolean(((Boolean)clause.getClauseValue()).booleanValue());
                    continue;
                }
                if (clause.getType().equals((Object)Attribute.Type.number)) {
                    jgen.writeNumber(String.valueOf(clause.getClauseValue()));
                    continue;
                }
                jgen.writeString((String)clause.getClauseValue());
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
            jgen.writeEndArray();
        }
    }
}

