/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.hotswap;

import com.jfinal.server.undertow.UndertowKit;
import com.jfinal.server.undertow.UndertowServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HotSwapWatcher
extends Thread {
    protected UndertowServer undertowServer;
    protected int watchingInterval = 500;
    protected List<Path> watchingPaths;
    private WatchKey watchKey;
    protected volatile boolean running = true;

    public HotSwapWatcher(UndertowServer undertowServer) {
        this.setName("HotSwapWatcher");
        this.setDaemon(false);
        this.setPriority(10);
        this.undertowServer = undertowServer;
        this.watchingPaths = this.buildWatchingPaths();
    }

    protected List<Path> buildWatchingPaths() {
        String[] classPathArray;
        HashSet<String> watchingDirSet = new HashSet<String>();
        for (String classPath : classPathArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            this.buildDirs(new File(classPath.trim()), watchingDirSet);
        }
        ArrayList dirList = new ArrayList(watchingDirSet);
        Collections.sort(dirList);
        ArrayList<Path> pathList = new ArrayList<Path>(dirList.size());
        for (String dir : dirList) {
            pathList.add(Paths.get(dir, new String[0]));
        }
        return pathList;
    }

    private void buildDirs(File file, Set<String> watchingDirSet) {
        if (file.isDirectory()) {
            File[] fileList;
            watchingDirSet.add(file.getPath());
            for (File f : fileList = file.listFiles()) {
                this.buildDirs(f, watchingDirSet);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void doRun() throws IOException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        this.addShutdownHook(watcher);
        for (Path path : this.watchingPaths) {
            path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        }
        while (this.running) {
            try {
                this.watchKey = watcher.take();
                if (this.watchKey == null) {
                    continue;
                }
            }
            catch (Throwable e) {
                this.running = false;
                if (!(e instanceof InterruptedException)) break;
                Thread.currentThread().interrupt();
                break;
            }
            List<WatchEvent<?>> watchEvents = this.watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                String fileName = event.context().toString();
                if (!fileName.endsWith(".class") || !this.undertowServer.isStarted()) continue;
                this.undertowServer.restart();
                this.resetWatchKey();
                while ((this.watchKey = watcher.poll()) != null) {
                    this.watchKey.pollEvents();
                    this.resetWatchKey();
                }
                break block4;
            }
            this.resetWatchKey();
        }
    }

    private void resetWatchKey() {
        if (this.watchKey != null) {
            this.watchKey.reset();
            this.watchKey = null;
        }
    }

    protected void addShutdownHook(WatchService watcher) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                watcher.close();
            }
            catch (Throwable e) {
                UndertowKit.doNothing(e);
            }
        }));
    }

    public void exit() {
        this.running = false;
        try {
            this.interrupt();
        }
        catch (Throwable e) {
            UndertowKit.doNothing(e);
        }
    }
}

