/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import com.jfinal.template.io.ByteWriter;
import com.jfinal.template.io.CharWriter;
import com.jfinal.template.io.EncoderFactory;
import com.jfinal.template.io.FastStringWriter;
import java.io.OutputStream;
import java.io.Writer;

public class WriterBuffer {
    private static final int MIN_BUFFER_SIZE = 64;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private int bufferSize = 1024;
    private int reentrantBufferSize = 128;
    private EncoderFactory encoderFactory = new EncoderFactory();
    private final ThreadLocal<ByteWriter> byteWriters = new ThreadLocal<ByteWriter>(){

        @Override
        protected ByteWriter initialValue() {
            return new ByteWriter(WriterBuffer.this.encoderFactory.getEncoder(), WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<CharWriter> charWriters = new ThreadLocal<CharWriter>(){

        @Override
        protected CharWriter initialValue() {
            return new CharWriter(WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<FastStringWriter> fastStringWriters = new ThreadLocal<FastStringWriter>(){

        @Override
        protected FastStringWriter initialValue() {
            return new FastStringWriter();
        }
    };

    public ByteWriter getByteWriter(OutputStream outputStream) {
        ByteWriter ret = this.byteWriters.get();
        if (ret.isInUse()) {
            ret = new ByteWriter(this.encoderFactory.getEncoder(), this.reentrantBufferSize);
        }
        return ret.init(outputStream);
    }

    public CharWriter getCharWriter(Writer writer) {
        CharWriter ret = this.charWriters.get();
        if (ret.isInUse()) {
            ret = new CharWriter(this.reentrantBufferSize);
        }
        return ret.init(writer);
    }

    public FastStringWriter getFastStringWriter() {
        FastStringWriter ret = this.fastStringWriters.get();
        if (ret.isInUse()) {
            ret = new FastStringWriter();
        }
        return ret.init();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 64 || bufferSize > 0x200000) {
            throw new IllegalArgumentException("bufferSize must between 63 and 2097153");
        }
        this.bufferSize = bufferSize;
    }

    public void setReentrantBufferSize(int reentrantBufferSize) {
        int min = 64;
        int max = 2048;
        if (reentrantBufferSize < min || reentrantBufferSize > max) {
            throw new IllegalArgumentException("reentrantBufferSize must between " + (min - 1) + " and " + (max + 1));
        }
        this.reentrantBufferSize = reentrantBufferSize;
    }

    public void setEncoderFactory(EncoderFactory encoderFactory) {
        if (encoderFactory == null) {
            throw new IllegalArgumentException("encoderFactory can not be null");
        }
        this.encoderFactory = encoderFactory;
    }

    public void setEncoding(String encoding) {
        this.encoderFactory.setEncoding(encoding);
    }
}

