/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Const;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Define;
import java.util.ArrayList;

public class CallDirective
extends Directive {
    protected Expr funcNameExpr;
    protected ExprList paraExpr;
    protected boolean nullSafe = false;

    @Override
    public void setExprList(ExprList exprList) {
        int len = exprList.length();
        if (len == 0) {
            throw new ParseException("Template function name required", this.location);
        }
        int index = 0;
        Expr expr = exprList.getExpr(index);
        if (expr instanceof Const && ((Const)expr).isBoolean()) {
            if (len == 1) {
                throw new ParseException("Template function name required", this.location);
            }
            this.nullSafe = ((Const)expr).getBoolean();
        }
        int n = ++index;
        this.funcNameExpr = exprList.getExpr(n);
        ArrayList<Expr> list = new ArrayList<Expr>();
        for (int i = ++index; i < len; ++i) {
            list.add(exprList.getExpr(i));
        }
        this.paraExpr = new ExprList(list);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object funcNameValue = this.funcNameExpr.eval(scope);
        if (funcNameValue == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("Template function name can not be null", this.location);
        }
        if (!(funcNameValue instanceof String)) {
            throw new TemplateException("Template function name must be String", this.location);
        }
        Define func = env.getFunction(funcNameValue.toString());
        if (func == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("Template function not found : " + funcNameValue, this.location);
        }
        func.call(env, scope, this.paraExpr, writer);
    }
}

