/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.content.FileProvider;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AppUtils {
    private static final String PERMISSION_ACTIVITY_CLASS_NAME = "com.blankj.utilcode.util.PermissionUtils$PermissionActivity";
    private static final ActivityLifecycleImpl ACTIVITY_LIFECYCLE = new ActivityLifecycleImpl();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApplication;

    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(Context context) {
        if (context == null) {
            AppUtils.init(AppUtils.getApplicationByReflect());
            return;
        }
        AppUtils.init((Application)context.getApplicationContext());
    }

    public static void init(Application app) {
        if (sApplication == null) {
            sApplication = app == null ? AppUtils.getApplicationByReflect() : app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        } else if (app != null && app.getClass() != sApplication.getClass()) {
            sApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
            AppUtils.ACTIVITY_LIFECYCLE.mActivityList.clear();
            sApplication = app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        }
    }

    public static Application getApp() {
        if (sApplication != null) {
            return sApplication;
        }
        Application app = AppUtils.getApplicationByReflect();
        AppUtils.init(app);
        return app;
    }

    private static Application getApplicationByReflect() {
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                throw new NullPointerException("u should init first");
            }
            return (Application)app;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }

    static ActivityLifecycleImpl getActivityLifecycle() {
        return ACTIVITY_LIFECYCLE;
    }

    static LinkedList<Activity> getActivityList() {
        return AppUtils.ACTIVITY_LIFECYCLE.mActivityList;
    }

    static Context getTopActivityOrApp() {
        if (AppUtils.isAppForeground()) {
            Activity topActivity = ACTIVITY_LIFECYCLE.getTopActivity();
            return topActivity == null ? AppUtils.getApp() : topActivity;
        }
        return AppUtils.getApp();
    }

    static boolean isAppForeground() {
        ActivityManager am = (ActivityManager)AppUtils.getApp().getSystemService("activity");
        if (am == null) {
            return false;
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            return aInfo.processName.equals(AppUtils.getApp().getPackageName());
        }
        return false;
    }

    public static interface OnActivityDestroyedListener {
        public void onActivityDestroyed(Activity var1);
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground();

        public void onBackground();
    }

    public static final class FileProvider4UtilCode
    extends FileProvider {
        public boolean onCreate() {
            AppUtils.init(this.getContext());
            return true;
        }
    }

    static class ActivityLifecycleImpl
    implements Application.ActivityLifecycleCallbacks {
        final LinkedList<Activity> mActivityList = new LinkedList();
        final Map<Object, OnAppStatusChangedListener> mStatusListenerMap = new HashMap<Object, OnAppStatusChangedListener>();
        final Map<Activity, Set<OnActivityDestroyedListener>> mDestroyedListenerMap = new HashMap<Activity, Set<OnActivityDestroyedListener>>();
        private int mForegroundCount = 0;
        private int mConfigCount = 0;
        private boolean mIsBackground = false;

        ActivityLifecycleImpl() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            this.setTopActivity(activity);
        }

        public void onActivityStarted(Activity activity) {
            if (!this.mIsBackground) {
                this.setTopActivity(activity);
            }
            if (this.mConfigCount < 0) {
                ++this.mConfigCount;
            } else {
                ++this.mForegroundCount;
            }
        }

        public void onActivityResumed(Activity activity) {
            this.setTopActivity(activity);
            if (this.mIsBackground) {
                this.mIsBackground = false;
                this.postStatus(true);
            }
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity.isChangingConfigurations()) {
                --this.mConfigCount;
            } else {
                --this.mForegroundCount;
                if (this.mForegroundCount <= 0) {
                    this.mIsBackground = true;
                    this.postStatus(false);
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.mActivityList.remove(activity);
            this.consumeOnActivityDestroyedListener(activity);
            ActivityLifecycleImpl.fixSoftInputLeaks(activity);
        }

        Activity getTopActivity() {
            Activity topActivity;
            if (!this.mActivityList.isEmpty() && (topActivity = this.mActivityList.getLast()) != null) {
                return topActivity;
            }
            Activity topActivityByReflect = this.getTopActivityByReflect();
            if (topActivityByReflect != null) {
                this.setTopActivity(topActivityByReflect);
            }
            return topActivityByReflect;
        }

        void addOnAppStatusChangedListener(Object object, OnAppStatusChangedListener listener) {
            this.mStatusListenerMap.put(object, listener);
        }

        void removeOnAppStatusChangedListener(Object object) {
            this.mStatusListenerMap.remove(object);
        }

        void removeOnActivityDestroyedListener(Activity activity) {
            if (activity == null) {
                return;
            }
            this.mDestroyedListenerMap.remove(activity);
        }

        void addOnActivityDestroyedListener(Activity activity, OnActivityDestroyedListener listener) {
            Set<Object> listeners;
            if (activity == null || listener == null) {
                return;
            }
            if (!this.mDestroyedListenerMap.containsKey(activity)) {
                listeners = new HashSet();
                this.mDestroyedListenerMap.put(activity, listeners);
            } else {
                listeners = this.mDestroyedListenerMap.get(activity);
                if (listeners.contains(listener)) {
                    return;
                }
            }
            listeners.add(listener);
        }

        private void postStatus(boolean isForeground) {
            if (this.mStatusListenerMap.isEmpty()) {
                return;
            }
            for (OnAppStatusChangedListener onAppStatusChangedListener : this.mStatusListenerMap.values()) {
                if (onAppStatusChangedListener == null) {
                    return;
                }
                if (isForeground) {
                    onAppStatusChangedListener.onForeground();
                    continue;
                }
                onAppStatusChangedListener.onBackground();
            }
        }

        private void setTopActivity(Activity activity) {
            if (AppUtils.PERMISSION_ACTIVITY_CLASS_NAME.equals(activity.getClass().getName())) {
                return;
            }
            if (this.mActivityList.contains(activity)) {
                if (!this.mActivityList.getLast().equals(activity)) {
                    this.mActivityList.remove(activity);
                    this.mActivityList.addLast(activity);
                }
            } else {
                this.mActivityList.addLast(activity);
            }
        }

        private void consumeOnActivityDestroyedListener(Activity activity) {
            Iterator<Map.Entry<Activity, Set<OnActivityDestroyedListener>>> iterator = this.mDestroyedListenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Activity, Set<OnActivityDestroyedListener>> entry = iterator.next();
                if (entry.getKey() != activity) continue;
                Set<OnActivityDestroyedListener> value = entry.getValue();
                for (OnActivityDestroyedListener listener : value) {
                    listener.onActivityDestroyed(activity);
                }
                iterator.remove();
            }
        }

        private Activity getTopActivityByReflect() {
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object currentActivityThreadMethod = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field mActivityListField = activityThreadClass.getDeclaredField("mActivityList");
                mActivityListField.setAccessible(true);
                Map activities = (Map)mActivityListField.get(currentActivityThreadMethod);
                if (activities == null) {
                    return null;
                }
                for (Object activityRecord : activities.values()) {
                    Class<?> activityRecordClass = activityRecord.getClass();
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                    Field activityField = activityRecordClass.getDeclaredField("activity");
                    activityField.setAccessible(true);
                    return (Activity)activityField.get(activityRecord);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return null;
        }

        private static void fixSoftInputLeaks(Activity activity) {
            String[] leakViews;
            if (activity == null) {
                return;
            }
            InputMethodManager imm = (InputMethodManager)AppUtils.getApp().getSystemService("input_method");
            if (imm == null) {
                return;
            }
            for (String leakView : leakViews = new String[]{"mLastSrvView", "mCurRootView", "mServedView", "mNextServedView"}) {
                try {
                    View view;
                    Object obj;
                    Field leakViewField = InputMethodManager.class.getDeclaredField(leakView);
                    if (leakViewField == null) continue;
                    if (!leakViewField.isAccessible()) {
                        leakViewField.setAccessible(true);
                    }
                    if (!((obj = leakViewField.get(imm)) instanceof View) || (view = (View)obj).getRootView() != activity.getWindow().getDecorView().getRootView()) continue;
                    leakViewField.set(imm, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

