/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.ipc.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.jeremyliao.liveeventbus.LiveEventBus;
import com.jeremyliao.liveeventbus.ipc.decode.IDecoder;
import com.jeremyliao.liveeventbus.ipc.decode.ValueDecoder;
import com.jeremyliao.liveeventbus.ipc.json.JsonConverter;

public class LebIpcReceiver
extends BroadcastReceiver {
    private IDecoder decoder;

    public LebIpcReceiver(JsonConverter jsonConverter) {
        this.decoder = new ValueDecoder(jsonConverter);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.decoder = new ValueDecoder(jsonConverter);
    }

    public void onReceive(Context context, Intent intent) {
        if ("intent.action.ACTION_LEB_IPC".equals(intent.getAction())) {
            try {
                String key = intent.getStringExtra("leb_ipc_key");
                Object value = this.decoder.decode(intent);
                if (key != null) {
                    LiveEventBus.get(key).post(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

