/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.ipc.encode;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.jeremyliao.liveeventbus.ipc.DataType;
import com.jeremyliao.liveeventbus.ipc.encode.EncodeException;
import com.jeremyliao.liveeventbus.ipc.encode.IEncoder;
import com.jeremyliao.liveeventbus.ipc.json.JsonConverter;
import java.io.Serializable;

public class ValueEncoder
implements IEncoder {
    private final JsonConverter jsonConverter;

    public ValueEncoder(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void encode(Intent intent, Object value) throws EncodeException {
        if (value instanceof String) {
            intent.putExtra("leb_ipc_value_type", DataType.STRING.ordinal());
            intent.putExtra("leb_ipc_value", (String)value);
        } else if (value instanceof Integer) {
            intent.putExtra("leb_ipc_value_type", DataType.INTEGER.ordinal());
            intent.putExtra("leb_ipc_value", ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            intent.putExtra("leb_ipc_value_type", DataType.BOOLEAN.ordinal());
            intent.putExtra("leb_ipc_value", ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            intent.putExtra("leb_ipc_value_type", DataType.LONG.ordinal());
            intent.putExtra("leb_ipc_value", ((Long)value).longValue());
        } else if (value instanceof Float) {
            intent.putExtra("leb_ipc_value_type", DataType.FLOAT.ordinal());
            intent.putExtra("leb_ipc_value", ((Float)value).floatValue());
        } else if (value instanceof Double) {
            intent.putExtra("leb_ipc_value_type", DataType.DOUBLE.ordinal());
            intent.putExtra("leb_ipc_value", ((Double)value).doubleValue());
        } else if (value instanceof Bundle) {
            intent.putExtra("leb_ipc_value_type", DataType.BUNDLE.ordinal());
            intent.putExtra("leb_ipc_value", (Bundle)value);
        } else if (value instanceof Parcelable) {
            intent.putExtra("leb_ipc_value_type", DataType.PARCELABLE.ordinal());
            intent.putExtra("leb_ipc_value", (Parcelable)value);
        } else if (value instanceof Serializable) {
            intent.putExtra("leb_ipc_value_type", DataType.SERIALIZABLE.ordinal());
            intent.putExtra("leb_ipc_value", (Serializable)value);
        } else {
            try {
                String json = this.jsonConverter.toJson(value);
                intent.putExtra("leb_ipc_value_type", DataType.JSON.ordinal());
                intent.putExtra("leb_ipc_value", json);
                intent.putExtra("leb_ipc_class_name", value.getClass().getCanonicalName());
            }
            catch (Exception e) {
                throw new EncodeException(e);
            }
        }
    }
}

