/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.ipc.decode;

import android.content.Intent;
import com.jeremyliao.liveeventbus.ipc.DataType;
import com.jeremyliao.liveeventbus.ipc.decode.DecodeException;
import com.jeremyliao.liveeventbus.ipc.decode.IDecoder;
import com.jeremyliao.liveeventbus.ipc.json.JsonConverter;

public class ValueDecoder
implements IDecoder {
    private final JsonConverter jsonConverter;

    public ValueDecoder(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object decode(Intent intent) throws DecodeException {
        int valueTypeIndex = intent.getIntExtra("leb_ipc_value_type", -1);
        if (valueTypeIndex < 0) {
            throw new DecodeException("Index Error");
        }
        DataType dataType = DataType.values()[valueTypeIndex];
        switch (dataType) {
            case STRING: {
                return intent.getStringExtra("leb_ipc_value");
            }
            case INTEGER: {
                return intent.getIntExtra("leb_ipc_value", -1);
            }
            case BOOLEAN: {
                return intent.getBooleanExtra("leb_ipc_value", false);
            }
            case LONG: {
                return intent.getLongExtra("leb_ipc_value", -1L);
            }
            case FLOAT: {
                return Float.valueOf(intent.getFloatExtra("leb_ipc_value", -1.0f));
            }
            case DOUBLE: {
                return intent.getDoubleExtra("leb_ipc_value", -1.0);
            }
            case PARCELABLE: {
                return intent.getParcelableExtra("leb_ipc_value");
            }
            case SERIALIZABLE: {
                return intent.getSerializableExtra("leb_ipc_value");
            }
            case BUNDLE: {
                return intent.getBundleExtra("leb_ipc_value");
            }
            case JSON: {
                try {
                    String json = intent.getStringExtra("leb_ipc_value");
                    String className = intent.getStringExtra("leb_ipc_class_name");
                    Class<?> classType = null;
                    try {
                        classType = Class.forName(className);
                        return this.jsonConverter.fromJson(json, classType);
                    }
                    catch (ClassNotFoundException e) {
                        int last = className.lastIndexOf(46);
                        if (last == -1) return this.jsonConverter.fromJson(json, classType);
                        String pn = className.substring(0, last);
                        String cn = className.substring(last + 1);
                        classType = Class.forName(pn + "$" + cn);
                    }
                    return this.jsonConverter.fromJson(json, classType);
                }
                catch (Exception e) {
                    throw new DecodeException(e);
                }
            }
        }
        throw new DecodeException();
    }
}

