/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.liveevent;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;

public class MainThreadManager {
    private final Object mLock = new Object();
    @Nullable
    private volatile Handler mMainHandler;

    public static MainThreadManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MainThreadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postToMainThread(Runnable runnable) {
        if (this.mMainHandler == null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mMainHandler == null) {
                    this.mMainHandler = new Handler(Looper.getMainLooper());
                }
            }
        }
        this.mMainHandler.post(runnable);
    }

    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private static class SingletonHolder {
        private static final MainThreadManager INSTANCE = new MainThreadManager();

        private SingletonHolder() {
        }
    }
}

