/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.liveevent;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jeremyliao.liveeventbus.liveevent.MainThreadManager;
import com.jeremyliao.liveeventbus.liveevent.SafeIterableMap;
import java.util.Map;

public abstract class LiveEvent<T> {
    private final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    private static final Object NOT_SET = new Object();
    private SafeIterableMap<Observer<T>, ObserverWrapper> mObservers = new SafeIterableMap();
    private int mActiveCount = 0;
    private volatile Object mData = NOT_SET;
    private volatile Object mPendingData = NOT_SET;
    private int mVersion = -1;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;

    private void considerNotify(ObserverWrapper observer) {
        if (!observer.mActive) {
            return;
        }
        if (!observer.shouldBeActive()) {
            observer.activeStateChanged(false);
            return;
        }
        if (observer.mLastVersion >= this.mVersion) {
            return;
        }
        observer.mLastVersion = this.mVersion;
        observer.mObserver.onChanged(this.mData);
    }

    private void dispatchingValue(@Nullable ObserverWrapper initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            SafeIterableMap.IteratorWithAdditions iterator = this.mObservers.iteratorWithAdditions();
            while (iterator.hasNext()) {
                this.considerNotify((ObserverWrapper)((Map.Entry)iterator.next()).getValue());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @MainThread
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner, observer);
        wrapper.mLastVersion = this.getVersion();
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer, wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void observeSticky(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner, observer);
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer, wrapper);
        if (existing != null && !existing.isAttachedTo(owner)) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void observeForever(@NonNull Observer<T> observer) {
        AlwaysActiveObserver wrapper = new AlwaysActiveObserver(observer);
        wrapper.mLastVersion = this.getVersion();
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer, wrapper);
        if (existing != null && existing instanceof LifecycleBoundObserver) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void observeStickyForever(@NonNull Observer<T> observer) {
        AlwaysActiveObserver wrapper = new AlwaysActiveObserver(observer);
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer, wrapper);
        if (existing != null && existing instanceof LifecycleBoundObserver) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void removeObserver(@NonNull Observer<T> observer) {
        LiveEvent.assertMainThread("removeObserver");
        ObserverWrapper removed = this.mObservers.remove(observer);
        if (removed == null) {
            return;
        }
        removed.detachObserver();
        removed.activeStateChanged(false);
    }

    @MainThread
    public void removeObservers(@NonNull LifecycleOwner owner) {
        LiveEvent.assertMainThread("removeObservers");
        for (Map.Entry<Observer<T>, ObserverWrapper> entry : this.mObservers) {
            if (!entry.getValue().isAttachedTo(owner)) continue;
            this.removeObserver(entry.getKey());
        }
    }

    public void postValue(T value) {
        MainThreadManager.getInstance().postToMainThread(new PostValueTask(value));
    }

    @MainThread
    public void setValue(T value) {
        LiveEvent.assertMainThread("setValue");
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasObservers() {
        return this.mObservers.size() > 0;
    }

    public boolean hasActiveObservers() {
        return this.mActiveCount > 0;
    }

    protected Lifecycle.State observerActiveLevel() {
        return Lifecycle.State.CREATED;
    }

    private static void assertMainThread(String methodName) {
        if (!MainThreadManager.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot invoke " + methodName + " on a background thread");
        }
    }

    private class AlwaysActiveObserver
    extends ObserverWrapper {
        AlwaysActiveObserver(Observer<T> observer) {
            super(observer);
        }

        @Override
        boolean shouldBeActive() {
            return true;
        }
    }

    private abstract class ObserverWrapper {
        final Observer<T> mObserver;
        boolean mActive;
        int mLastVersion = -1;

        ObserverWrapper(Observer<T> observer) {
            this.mObserver = observer;
        }

        abstract boolean shouldBeActive();

        boolean isAttachedTo(LifecycleOwner owner) {
            return false;
        }

        void detachObserver() {
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.mActive) {
                return;
            }
            this.mActive = newActive;
            boolean wasInactive = LiveEvent.this.mActiveCount == 0;
            LiveEvent liveEvent = LiveEvent.this;
            liveEvent.mActiveCount = liveEvent.mActiveCount + (this.mActive ? 1 : -1);
            if (wasInactive && this.mActive) {
                LiveEvent.this.onActive();
            }
            if (LiveEvent.this.mActiveCount == 0 && !this.mActive) {
                LiveEvent.this.onInactive();
            }
            if (this.mActive) {
                LiveEvent.this.dispatchingValue(this);
            }
        }
    }

    class LifecycleBoundObserver
    extends ObserverWrapper
    implements GenericLifecycleObserver {
        @NonNull
        final LifecycleOwner mOwner;

        LifecycleBoundObserver(LifecycleOwner owner, Observer<T> observer) {
            super(observer);
            this.mOwner = owner;
        }

        @Override
        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(LiveEvent.this.observerActiveLevel());
        }

        public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
            if (this.mOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                LiveEvent.this.removeObserver(this.mObserver);
                return;
            }
            this.activeStateChanged(this.shouldBeActive());
        }

        @Override
        boolean isAttachedTo(LifecycleOwner owner) {
            return this.mOwner == owner;
        }

        @Override
        void detachObserver() {
            this.mOwner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    private class PostValueTask
    implements Runnable {
        private Object newValue;

        public PostValueTask(Object newValue) {
            this.newValue = newValue;
        }

        @Override
        public void run() {
            LiveEvent.this.setValue(this.newValue);
        }
    }
}

