/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.jeremyliao.liveeventbus.liveevent.LiveEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class LiveEventBus {
    private final Map<String, BusLiveEvent<Object>> bus = new HashMap<String, BusLiveEvent<Object>>();

    private LiveEventBus() {
    }

    public static LiveEventBus get() {
        return SingletonHolder.DEFAULT_BUS;
    }

    public synchronized <T> Observable<T> with(String key, Class<T> type) {
        if (!this.bus.containsKey(key)) {
            this.bus.put(key, new BusLiveEvent(key));
        }
        return this.bus.get(key);
    }

    public Observable<Object> with(String key) {
        return this.with(key, Object.class);
    }

    private static class BusLiveEvent<T>
    extends LiveEvent<T>
    implements Observable<T> {
        @NonNull
        private final String key;
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private BusLiveEvent(String key) {
            this.key = key;
        }

        @Override
        protected Lifecycle.State observerActiveLevel() {
            return super.observerActiveLevel();
        }

        @Override
        public void postValueDelay(T value, long delay, TimeUnit unit) {
            this.mainHandler.postDelayed((Runnable)new PostValueTask(value), unit.convert(delay, unit));
        }

        @Override
        public void removeObserver(@NonNull Observer<T> observer) {
            super.removeObserver(observer);
            if (!this.hasObservers()) {
                LiveEventBus.get().bus.remove(this.key);
            }
        }

        private class PostValueTask
        implements Runnable {
            private Object newValue;

            public PostValueTask(Object newValue) {
                this.newValue = newValue;
            }

            @Override
            public void run() {
                BusLiveEvent.this.setValue(this.newValue);
            }
        }
    }

    public static interface Observable<T> {
        public void setValue(T var1);

        public void postValue(T var1);

        public void postValueDelay(T var1, long var2, TimeUnit var4);

        public void observe(@NonNull LifecycleOwner var1, @NonNull Observer<T> var2);

        public void observeSticky(@NonNull LifecycleOwner var1, @NonNull Observer<T> var2);

        public void observeForever(@NonNull Observer<T> var1);

        public void observeStickyForever(@NonNull Observer<T> var1);

        public void removeObserver(@NonNull Observer<T> var1);
    }

    private static class SingletonHolder {
        private static final LiveEventBus DEFAULT_BUS = new LiveEventBus();

        private SingletonHolder() {
        }
    }
}

