/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.dataloader.core;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.jeremyliao.dataloader.interfaces.LoadListener;
import com.jeremyliao.dataloader.interfaces.LoadTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class DataLoadTask<T>
implements Runnable {
    final MutableLiveData<T> liveData = new MutableLiveData();
    final LoadTask<T> loadTask;
    private Map<LoadListener<T>, Observer<T>> listenerObserverMap = new ConcurrentHashMap<LoadListener<T>, Observer<T>>();

    DataLoadTask(@NonNull LoadTask<T> loadTask) {
        this.loadTask = loadTask;
    }

    @MainThread
    void addListener(@NonNull LifecycleOwner owner, final @NonNull LoadListener<T> listener) {
        this.liveData.observe(owner, new Observer<T>(){

            public void onChanged(@Nullable T t) {
                listener.onDataArrived(t);
            }
        });
    }

    @MainThread
    void addListener(final @NonNull LoadListener<T> listener) {
        Observer observer = new Observer<T>(){

            public void onChanged(@Nullable T t) {
                listener.onDataArrived(t);
            }
        };
        this.listenerObserverMap.put(listener, observer);
        this.liveData.observeForever(observer);
    }

    @MainThread
    void removeListener(@NonNull LoadListener<T> listener) {
        if (this.listenerObserverMap.containsKey(listener)) {
            Observer<T> observer = this.listenerObserverMap.remove(listener);
            this.liveData.removeObserver(observer);
        }
    }

    @Override
    @WorkerThread
    public void run() {
        T t = this.loadTask.loadData();
        this.liveData.postValue(t);
    }
}

