/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.ClasspathResolver;
import com.jcabi.xml.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import lombok.Generated;
import org.cactoos.Scalar;
import org.cactoos.scalar.Sticky;
import org.cactoos.scalar.Unchecked;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXParseException;

public final class StrictXML
implements XML {
    private final transient Unchecked<XML> origin;

    public StrictXML(XML xml) {
        this(xml, new ClasspathResolver());
    }

    public StrictXML(XML xml, LSResourceResolver resolver) {
        this(xml, (Scalar<Collection<SAXParseException>>)((Scalar)() -> xml.validate(resolver)));
    }

    public StrictXML(XML xml, XML schema) {
        this(xml, (Scalar<Collection<SAXParseException>>)((Scalar)() -> xml.validate(schema)));
    }

    private StrictXML(XML xml, Scalar<Collection<SAXParseException>> errs) {
        this((Scalar<XML>)((Scalar)() -> {
            Collection errors = (Collection)errs.value();
            if (!errors.isEmpty()) {
                Logger.warn(StrictXML.class, (String)"%d XML validation error(s):\n  %s\n%s", (Object[])new Object[]{errors.size(), StrictXML.join(StrictXML.print(errors), "\n  "), xml});
                throw new IllegalArgumentException(String.format("%d error(s) in XML document: %s", errors.size(), StrictXML.join(StrictXML.print(errors), ";")));
            }
            return xml;
        }));
    }

    private StrictXML(Scalar<XML> xml) {
        this.origin = new Unchecked((Scalar)new Sticky(xml));
    }

    public String toString() {
        return ((XML)this.origin.value()).toString();
    }

    @Override
    public List<String> xpath(String query) {
        return ((XML)this.origin.value()).xpath(query);
    }

    @Override
    public List<XML> nodes(String query) {
        return ((XML)this.origin.value()).nodes(query);
    }

    @Override
    public XML registerNs(String prefix, Object uri) {
        return ((XML)this.origin.value()).registerNs(prefix, uri);
    }

    @Override
    public XML merge(NamespaceContext context) {
        return ((XML)this.origin.value()).merge(context);
    }

    @Override
    @Deprecated
    public Node node() {
        return ((XML)this.origin.value()).deepCopy();
    }

    @Override
    public Node inner() {
        return ((XML)this.origin.value()).inner();
    }

    @Override
    public Node deepCopy() {
        return ((XML)this.origin.value()).deepCopy();
    }

    @Override
    public Collection<SAXParseException> validate(LSResourceResolver resolver) {
        return ((XML)this.origin.value()).validate(resolver);
    }

    @Override
    public Collection<SAXParseException> validate(XML xsd) {
        return ((XML)this.origin.value()).validate(xsd);
    }

    private static Iterable<String> print(Collection<SAXParseException> errors) {
        ArrayList<String> lines = new ArrayList<String>(errors.size());
        for (SAXParseException error : errors) {
            lines.add(StrictXML.asMessage(error));
        }
        return lines;
    }

    private static String asMessage(SAXParseException violation) {
        StringBuilder msg = new StringBuilder(100);
        if (violation.getLineNumber() >= 0) {
            msg.append('#').append(violation.getLineNumber());
            if (violation.getColumnNumber() >= 0) {
                msg.append(':').append(violation.getColumnNumber());
            }
            msg.append(' ');
        }
        msg.append(violation.getLocalizedMessage());
        if (violation.getException() != null) {
            msg.append(" (").append(violation.getException().getClass().getSimpleName()).append(')');
        }
        return msg.toString();
    }

    private static String join(Iterable<?> iterable, String sep) {
        Iterator<?> iterator = iterable.iterator();
        Object first = iterator.next();
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(sep);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrictXML)) {
            return false;
        }
        StrictXML other = (StrictXML)o;
        Unchecked<XML> this$origin = this.origin;
        Unchecked<XML> other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Unchecked<XML> $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

