/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XSL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;

public final class XSLChain
implements XSL {
    private final transient XSL[] sheets;

    public XSLChain(XSL ... shts) {
        this(Arrays.asList(shts));
    }

    public XSLChain(Collection<XSL> shts) {
        this.sheets = shts.toArray(new XSL[0]);
    }

    @Override
    public XML transform(XML xml) {
        XML output = xml;
        for (XSL sheet : this.sheets) {
            output = sheet.transform(output);
        }
        return output;
    }

    @Override
    public String applyTo(XML xml) {
        throw new UnsupportedOperationException("#applyTo()");
    }

    @Override
    public XSL with(Sources src) {
        ArrayList<XSL> list = new ArrayList<XSL>(this.sheets.length);
        for (XSL sheet : this.sheets) {
            list.add(sheet.with(src));
        }
        return new XSLChain(list);
    }

    @Override
    public XSL with(String name, Object value) {
        ArrayList<XSL> list = new ArrayList<XSL>(this.sheets.length);
        for (XSL sheet : this.sheets) {
            list.add(sheet.with(name, value));
        }
        return new XSLChain(list);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSLChain)) {
            return false;
        }
        XSLChain other = (XSLChain)o;
        return Arrays.deepEquals(this.sheets, other.sheets);
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.sheets);
        return result;
    }
}

