/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

final class TextResource {
    private final transient String content;

    private TextResource(String text) {
        this.content = text;
    }

    TextResource(InputStream stream) {
        this(TextResource.readAsString(stream));
    }

    TextResource(File file) throws FileNotFoundException {
        this(TextResource.readAsString(new BufferedInputStream(new FileInputStream(file))));
    }

    TextResource(URL url) throws IOException {
        this(TextResource.readAsString(url));
    }

    TextResource(URI uri) throws IOException {
        this(TextResource.readAsString(uri.toURL()));
    }

    public String toString() {
        return this.content;
    }

    private static String readAsString(InputStream stream) {
        String result;
        try (Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");){
            result = scanner.hasNext() ? scanner.next() : "";
        }
        return result;
    }

    private static String readAsString(URL url) throws IOException {
        return TextResource.readAsString(new BufferedInputStream(url.openStream()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextResource)) {
            return false;
        }
        TextResource other = (TextResource)o;
        String this$content = this.content;
        String other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

