/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XSL;
import java.util.Arrays;
import java.util.Collection;
import javax.validation.constraints.NotNull;

public final class XSLChain
implements XSL {
    private final transient XSL[] sheets;

    public XSLChain(@NotNull(message="list of stylesheets can't be NULL") Collection<XSL> shts) {
        this.sheets = shts.toArray(new XSL[shts.size()]);
    }

    @Override
    public XML transform(@NotNull(message="XML can't be NULL") XML xml) {
        XML output = xml;
        for (XSL sheet : this.sheets) {
            output = sheet.transform(output);
        }
        return output;
    }

    @Override
    public String applyTo(XML xml) {
        throw new UnsupportedOperationException("#applyTo()");
    }

    @Override
    public XSL with(Sources src) {
        throw new UnsupportedOperationException("#with()");
    }

    @Override
    public XSL with(String name, String value) {
        throw new UnsupportedOperationException("#with(name, value)");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSLChain)) {
            return false;
        }
        XSLChain other = (XSLChain)o;
        return Arrays.deepEquals(this.sheets, other.sheets);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.sheets);
        return result;
    }
}

