/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import org.cactoos.io.DeadInput;
import org.cactoos.io.TeeOutputStream;

@Immutable
public interface Shell {
    public int exec(String var1, InputStream var2, OutputStream var3, OutputStream var4) throws IOException;

    @Immutable
    public static final class Verbose
    implements Shell {
        private final transient Shell orgn;

        public Verbose(Shell shell) {
            this.orgn = shell;
        }

        @Override
        public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
            return this.orgn.exec(command, stdin, (OutputStream)new TeeOutputStream(stdout, Logger.stream((Level)Level.INFO, (Object)this)), (OutputStream)new TeeOutputStream(stderr, Logger.stream((Level)Level.WARNING, (Object)this)));
        }

        public String toString() {
            return "Shell.Verbose(orgn=" + this.orgn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verbose)) {
                return false;
            }
            Verbose other = (Verbose)o;
            Shell this$orgn = this.orgn;
            Shell other$orgn = other.orgn;
            return !(this$orgn == null ? other$orgn != null : !this$orgn.equals(other$orgn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Shell $orgn = this.orgn;
            result = result * 59 + ($orgn == null ? 43 : $orgn.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Plain {
        private final transient Shell origin;

        public Plain(Shell shell) {
            this.origin = shell;
        }

        public String exec(String cmd) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.origin.exec(cmd, new DeadInput().stream(), baos, baos);
            return baos.toString(StandardCharsets.UTF_8.toString());
        }

        public String toString() {
            return "Shell.Plain(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plain)) {
                return false;
            }
            Plain other = (Plain)o;
            Shell this$origin = this.origin;
            Shell other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Shell $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Empty {
        private final transient Shell origin;

        public Empty(Shell shell) {
            this.origin = shell;
        }

        public int exec(String cmd) throws IOException {
            return this.origin.exec(cmd, new DeadInput().stream(), Logger.stream((Level)Level.INFO, (Object)this), Logger.stream((Level)Level.WARNING, (Object)this));
        }

        public String toString() {
            return "Shell.Empty(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            Shell this$origin = this.origin;
            Shell other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Shell $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Safe
    implements Shell {
        private final transient Shell origin;

        public Safe(Shell shell) {
            this.origin = shell;
        }

        @Override
        public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
            int exit = this.origin.exec(command, stdin, stdout, stderr);
            if (exit != 0) {
                throw new IllegalArgumentException(String.format("non-zero exit code #%d: %s", exit, command));
            }
            return exit;
        }

        public String toString() {
            return "Shell.Safe(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Safe)) {
                return false;
            }
            Safe other = (Safe)o;
            Shell this$origin = this.origin;
            Shell other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Shell $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Fake
    implements Shell {
        private final int code;
        private final byte[] stdout;
        private final byte[] stderr;

        public Fake() {
            this(0, "", "");
        }

        public Fake(int exit, String out, String err) {
            this(exit, out.getBytes(), err.getBytes());
        }

        public Fake(int exit, byte[] out, byte[] err) {
            this.code = exit;
            this.stdout = out;
            this.stderr = err;
        }

        @Override
        public int exec(String command, InputStream stdin, OutputStream sout, OutputStream serr) throws IOException {
            while (stdin.read(new byte[2048]) >= 0) {
            }
            sout.write(this.stdout);
            sout.close();
            serr.write(this.stderr);
            serr.close();
            return this.code;
        }

        public String toString() {
            return "Shell.Fake(code=" + this.code + ", stdout=" + Arrays.toString(this.stdout) + ", stderr=" + Arrays.toString(this.stderr) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fake)) {
                return false;
            }
            Fake other = (Fake)o;
            return this.code == other.code;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.code;
            return result;
        }
    }
}

