/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.log.Logger;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

final class Execution {
    private final transient String command;
    private final transient InputStream stdin;
    private final transient OutputStream stdout;
    private final transient OutputStream stderr;
    private final transient Session session;

    Execution(String cmd, InputStream input, OutputStream out, OutputStream err, Session sess) {
        this.command = cmd;
        this.stdin = input;
        this.stdout = out;
        this.stderr = err;
        this.session = sess;
    }

    public int exec() throws IOException {
        try {
            ChannelExec channel = (ChannelExec)ChannelExec.class.cast(this.session.openChannel("exec"));
            channel.setErrStream(this.stderr, false);
            channel.setOutputStream(this.stdout, false);
            channel.setInputStream(this.stdin, false);
            channel.setCommand(this.command);
            channel.setPty(false);
            channel.connect((int)TimeUnit.SECONDS.toMillis(10L));
            Logger.info((Object)this, (String)"+ %s", (Object[])new Object[]{this.command});
            int n = this.exec(channel);
            return n;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
        finally {
            this.session.disconnect();
        }
    }

    private int exec(ChannelExec channel) throws IOException {
        try {
            int n = this.code(channel);
            return n;
        }
        finally {
            channel.disconnect();
        }
    }

    private int code(ChannelExec channel) throws IOException {
        long start = System.currentTimeMillis();
        while (!channel.isClosed()) {
            try {
                this.session.sendKeepAliveMsg();
            }
            catch (Exception ex) {
                throw new IOException("Failed to sendKeepAliveMsg() to the SSH session", ex);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted after %[ms]s of waiting", System.currentTimeMillis() - start), ex);
            }
            if (!Logger.isDebugEnabled((Object)this)) continue;
            try {
                Logger.debug((Object)this, (String)"Waiting for SSH session to %s:%d to close, already %[ms]s...", (Object[])new Object[]{channel.getSession().getHost(), channel.getSession().getPort(), System.currentTimeMillis() - start});
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
        return channel.getExitStatus();
    }
}

