/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.ssh.Execution;
import com.jcabi.ssh.JschLogger;
import com.jcabi.ssh.Shell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public final class SSHByPassword
implements Shell {
    private final transient String addr;
    private final transient int port;
    private final transient String login;
    private final transient String password;

    public SSHByPassword(String adr, int prt, String user, String passwd) throws UnknownHostException {
        this.addr = InetAddress.getByName(adr).getHostAddress();
        Validate.matchesPattern((CharSequence)this.addr, (String)"\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", (String)"Invalid IP address of the server `%s`", (Object[])new Object[]{this.addr});
        this.port = prt;
        this.login = user;
        Validate.notEmpty((CharSequence)this.login, (String)"user name can't be empty", (Object[])new Object[0]);
        this.password = passwd;
    }

    @Override
    public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        return new Execution.Default(command, stdin, stdout, stderr, this.session()).exec();
    }

    @RetryOnFailure(attempts=7, delay=1L, unit=TimeUnit.MINUTES, verbose=false, randomize=true, types={IOException.class})
    private Session session() throws IOException {
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            JSch.setLogger((Logger)new JschLogger());
            JSch jsch = new JSch();
            com.jcabi.log.Logger.debug((Object)this, (String)"Opening SSH session to %s@%s:%s (auth with password)...", (Object[])new Object[]{this.login, this.addr, this.port});
            Session session = jsch.getSession(this.login, this.addr, this.port);
            session.setPassword(this.password);
            session.setServerAliveInterval((int)TimeUnit.SECONDS.toMillis(10L));
            session.setServerAliveCountMax(1000000);
            session.connect();
            return session;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public String toString() {
        return "SSHByPassword(addr=" + this.addr + ", port=" + this.port + ", login=" + this.login + ", password=" + this.password + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSHByPassword)) {
            return false;
        }
        SSHByPassword other = (SSHByPassword)o;
        String this$addr = this.addr;
        String other$addr = other.addr;
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        String this$login = this.login;
        String other$login = other.login;
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addr = this.addr;
        result = result * 59 + ($addr == null ? 0 : $addr.hashCode());
        result = result * 59 + this.port;
        String $login = this.login;
        result = result * 59 + ($login == null ? 0 : $login.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 0 : $password.hashCode());
        return result;
    }
}

