/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class VerboseThreads
implements ThreadFactory {
    private final transient ThreadGroup group;
    private final transient String prefix;
    private final transient AtomicInteger number = new AtomicInteger(1);
    private final transient boolean daemon;
    private final transient int priority;

    public VerboseThreads() {
        this("verbose", true, 1);
    }

    public VerboseThreads(String pfx) {
        this(pfx, true, 1);
    }

    public VerboseThreads(Object type) {
        this(type.getClass().getSimpleName(), true, 1);
    }

    public VerboseThreads(Class<?> type) {
        this(type.getSimpleName(), true, 1);
    }

    public VerboseThreads(String pfx, boolean dmn, int prt) {
        this.prefix = pfx;
        this.daemon = dmn;
        this.priority = prt;
        this.group = new ThreadGroup(pfx){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Logger.warn(this, "%[exception]s", throwable);
            }
        };
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        Thread thread = new Thread(this.group, new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (RuntimeException ex) {
                    Logger.warn(this, "%s: %[exception]s", Thread.currentThread().getName(), ex);
                    throw ex;
                }
                catch (Error error) {
                    Logger.error(this, "%s (error): %[exception]s", Thread.currentThread().getName(), error);
                    throw error;
                }
            }
        });
        thread.setName(String.format("%s-%d", this.prefix, this.number.getAndIncrement()));
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }
}

